/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.crosschain.base.message.BroadCtxSignMessage;
import io.nuls.crosschain.base.message.CtxFullSignMessage;
import io.nuls.crosschain.base.message.GetOtherCtxMessage;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.VerifierChangeData;
import io.nuls.crosschain.base.service.ResetLocalVerifierService;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.NodeType;
import io.nuls.crosschain.model.bo.message.WaitBroadSignMessage;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.model.po.SendCtxHashPO;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.rpc.call.TransactionCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.SendHeightService;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Component
public class MessageUtil {
    @Autowired
    private static ConvertHashService convertHashService;
    @Autowired
    private static NulsCoresConfig config;
    @Autowired
    private static ChainManager chainManager;
    @Autowired
    private static ConvertCtxService convertCtxService;
    @Autowired
    private static CtxStatusService ctxStatusService;
    @Autowired
    private static SendHeightService sendHeightService;
    @Autowired
    private static ResetLocalVerifierService resetLocalVerifierService;

    public static void handleSignMessage(Chain chain, NulsHash hash, int chainId, String nodeId, BroadCtxSignMessage messageBody, String hashHex) {
        try {
            int handleChainId = chain.getChainId();
            CtxStatusPO ctxStatusPO = ctxStatusService.get(hash, handleChainId);
            if (ctxStatusPO.getStatus() != TxStatusEnum.UNCONFIRM.getStatus() || messageBody.getSignature() == null) {
                chain.getLogger().info("Cross chain transactions have been processed at this node,Hash:{}\n\n", new Object[]{hashHex});
                return;
            }
            String signHex = HexUtil.encode((byte[])messageBody.getSignature());
            P2PHKSignature p2PHKSignature = new P2PHKSignature();
            p2PHKSignature.parse(messageBody.getSignature(), 0);
            Transaction convertCtx = ctxStatusPO.getTx();
            if (config.getCrossTxDropTime() > convertCtx.getTime()) {
                chain.getLogger().warn("The cross-chain transaction has expired and is no longer processed");
                return;
            }
            if (!config.isMainNet() && convertCtx.getType() == config.getCrossCtxType()) {
                convertCtx = convertCtxService.get(hash, handleChainId);
            }
            if (!ECKey.verify((byte[])convertCtx.getHash().getBytes(), (byte[])p2PHKSignature.getSignData().getSignBytes(), (byte[])p2PHKSignature.getPublicKey())) {
                chain.getLogger().info("Signature verification error,hash:{},autograph:{}\n\n", new Object[]{hashHex, signHex});
                return;
            }
            MessageUtil.signByzantine(chain, chainId, hash, ctxStatusPO.getTx(), messageBody, hashHex, signHex, nodeId);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
        }
        catch (IOException io) {
            chain.getLogger().error((Exception)io);
        }
    }

    public static void handleNewHashMessage(Chain chain, NulsHash cacheHash, int chainId, String nodeId, String hashHex) {
        for (int tryCount = 0; chain.getOtherCtxStageMap().get(cacheHash) != null && chain.getOtherCtxStageMap().get(cacheHash) == 1 && tryCount < 5; ++tryCount) {
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                chain.getLogger().error(e);
            }
        }
        if (chain.getOtherCtxStageMap().get(cacheHash) != null && chain.getOtherCtxStageMap().get(cacheHash) == 1) {
            GetOtherCtxMessage responseMessage = new GetOtherCtxMessage();
            responseMessage.setRequestHash(cacheHash);
            NetWorkCall.sendToNode(chainId, responseMessage, nodeId, "getOtherCtx");
            chain.getLogger().info("Get transaction timeout, send to cross chain nodes{}Retrieve complete cross chain transactions again,Hash:{}", new Object[]{nodeId, hashHex});
        } else {
            chain.getOtherHashNodeIdMap().putIfAbsent(cacheHash, new ArrayList());
            chain.getOtherHashNodeIdMap().get(cacheHash).add(new NodeType(nodeId, 1));
        }
        chain.getLogger().debug("Cross chain nodes{}Cross chain transactions broadcasted overHashOr signature message processing completed,Hash\uff1a{}\n\n", new Object[]{nodeId, hashHex});
    }

    public static void signByzantine(Chain chain, int chainId, NulsHash realHash, Transaction ctx, BroadCtxSignMessage messageBody, String nativeHex, String signHex, String excludeNodes) throws NulsException, IOException {
        List packAddressList;
        TransactionSignature signature = new TransactionSignature();
        if (ctx.getTransactionSignature() != null) {
            signature.parse(ctx.getTransactionSignature(), 0);
            for (P2PHKSignature sign : signature.getP2PHKSignatures()) {
                if (!Arrays.equals(messageBody.getSignature(), sign.serialize())) continue;
                chain.getLogger().debug("This node has already received the signature for the cross chain transaction,Hash:{},autograph:{}\n\n", new Object[]{nativeHex, signHex});
                return;
            }
        } else {
            ArrayList p2PHKSignatureList = new ArrayList();
            signature.setP2PHKSignatures(p2PHKSignatureList);
        }
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.parse(messageBody.getSignature(), 0);
        signature.getP2PHKSignatures().add(p2PHKSignature);
        Float signCountOverflow = Float.valueOf(0.0f);
        if (ctx.getType() == 25) {
            String txHash = realHash.toHex();
            if (resetLocalVerifierService.isResetOtherVerifierTx(txHash)) {
                packAddressList = chain.getVerifierList();
                signCountOverflow = Float.valueOf(1.0f);
            } else {
                packAddressList = (List)ConsensusCall.getSeedNodeList(chain).get("packAddressList");
            }
        } else {
            packAddressList = chain.getVerifierList();
        }
        boolean byzantineSignIsDone = MessageUtil.signByzantineInChain(chain, ctx, signature, packAddressList, realHash, signCountOverflow);
        if (byzantineSignIsDone) {
            chain.getLogger().debug("The local Byzantine signature collection is complete and the signature is passed back to the node that sent the signature,to node:{}", new Object[]{excludeNodes});
            CtxFullSignMessage ctxFullSignMessage = new CtxFullSignMessage();
            ctxFullSignMessage.setLocalTxHash(realHash);
            ctxFullSignMessage.setTransactionSignature(ctx.getTransactionSignature());
            NetWorkCall.sendToNode(chainId, ctxFullSignMessage, excludeNodes, "recvCtxFullSign");
        }
        NetWorkCall.broadcast(chainId, messageBody, excludeNodes, "recvCtxSign", false);
        chain.getLogger().info("Broadcast newly received cross chain transaction signatures to other nodes linked to them,Hash:{} ,autograph:{} ,node: {}", new Object[]{nativeHex, signHex, excludeNodes});
    }

    public static boolean signByzantineInChain(Chain chain, Transaction ctx, TransactionSignature signature, List<String> packAddressList, NulsHash realHash, Float signCountOverflow) throws NulsException, IOException {
        if (ctx.getType() == 25) {
            return MessageUtil.verifierInitLocalByzantine(chain, ctx, signature, packAddressList, realHash, signCountOverflow);
        }
        if (ctx.getType() == 24) {
            return MessageUtil.verifierChangeLocalByzantine(chain, ctx, signature, realHash);
        }
        return MessageUtil.crossTransferLocalByzantine(chain, ctx, signature, realHash);
    }

    public static boolean signByzantineInChain(Chain chain, Transaction ctx, TransactionSignature signature, List<String> packAddressList, NulsHash realHash) throws NulsException, IOException {
        return MessageUtil.signByzantineInChain(chain, ctx, signature, packAddressList, realHash, Float.valueOf(0.0f));
    }

    public static boolean verifierInitLocalByzantine(Chain chain, Transaction ctx, TransactionSignature signature, List<String> packAddressList, NulsHash realHash, Float signCountOverflow) throws IOException {
        ArrayList<String> handleAddressList = new ArrayList<String>(packAddressList);
        int agentCount = handleAddressList.size();
        int byzantineCount = CommonUtil.getByzantineCount(chain, agentCount);
        int signCount = signature.getSignersCount();
        CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.UNCONFIRM.getStatus());
        if (signCount >= byzantineCount) {
            List<P2PHKSignature> misMatchSignList = CommonUtil.getMisMatchSigns(chain, signature, handleAddressList);
            signCount = signature.getSignersCount();
            if (signCount >= byzantineCount) {
                int fullByzantineCount;
                ctx.setTransactionSignature(signature.serialize());
                long sendHeight = config.getSendHeight();
                if (chainManager.getChainHeaderMap().get(chain.getChainId()) != null) {
                    sendHeight = chainManager.getChainHeaderMap().get(chain.getChainId()).getHeight();
                }
                MessageUtil.saveCtxSendHeight(chain, sendHeight, ctx);
                chain.getLogger().info("Initial verifier transaction signature Byzantine verification passed,Save the height change of the verifier and wait for broadcast,Hash{},Broadcasting height{}", new Object[]{ctx.getHash().toHex(), sendHeight});
                if (signCountOverflow == null) {
                    signCountOverflow = Float.valueOf(0.0f);
                }
                if (signCount >= (fullByzantineCount = byzantineCount + (int)((float)(agentCount - byzantineCount) * signCountOverflow.floatValue()))) {
                    chain.getLogger().info("The number of initial verifier transaction signatures has reached saturation:{},ctxSet toCONFIRMEDStatus, this node will no longer process this transaction", new Object[]{signCount});
                    ctxStatusPO.setStatus(TxStatusEnum.CONFIRMED.getStatus());
                    resetLocalVerifierService.finishResetOtherVerifierTx(realHash.toHex());
                } else {
                    chain.getLogger().debug("The number of initial verifier transaction signatures has reached the minimum number of signatures:{}, but to reach saturation signature count:{}This section will continue to process this transaction", new Object[]{signCount, fullByzantineCount});
                }
                ctxStatusService.save(realHash, ctxStatusPO, chain.getChainId());
                return true;
            }
            signature.getP2PHKSignatures().addAll(misMatchSignList);
            ctx.setTransactionSignature(signature.serialize());
        } else {
            ctx.setTransactionSignature(signature.serialize());
        }
        ctxStatusService.save(realHash, ctxStatusPO, chain.getChainId());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifierChangeLocalByzantine(Chain chain, Transaction ctx, TransactionSignature signature, NulsHash realHash) throws NulsException, IOException {
        ArrayList<String> handleAddressList;
        try {
            chain.getSwitchVerifierLock().readLock().lock();
            handleAddressList = new ArrayList<String>(chain.getVerifierList());
        }
        finally {
            chain.getSwitchVerifierLock().readLock().unlock();
        }
        VerifierChangeData txData = new VerifierChangeData();
        txData.parse(ctx.getTxData(), 0);
        if (txData.getCancelAgentList() != null && !txData.getCancelAgentList().isEmpty()) {
            handleAddressList.removeAll(txData.getCancelAgentList());
        }
        int agentCount = handleAddressList.size();
        int byzantineCount = CommonUtil.getByzantineCount(chain, agentCount);
        int signCount = signature.getSignersCount();
        CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.UNCONFIRM.getStatus());
        if (signCount >= byzantineCount) {
            List<P2PHKSignature> misMatchSignList = CommonUtil.getMisMatchSigns(chain, signature, handleAddressList);
            signCount = signature.getSignersCount();
            if (signCount >= byzantineCount) {
                ctx.setTransactionSignature(signature.serialize());
                ctxStatusPO.setStatus(TxStatusEnum.BYZANTINE_COMPLETE.getStatus());
                ctxStatusService.save(realHash, ctxStatusPO, chain.getChainId());
                TransactionCall.sendTx(chain, RPCUtil.encode((byte[])ctx.serialize()));
                chain.getLogger().info("Verifier changes transaction signature Byzantine verification passed,Broadcast cross chain transactions to the transaction module for processing,Hash{}", new Object[]{ctx.getHash().toHex()});
                return true;
            }
            signature.getP2PHKSignatures().addAll(misMatchSignList);
            ctx.setTransactionSignature(signature.serialize());
        } else {
            ctx.setTransactionSignature(signature.serialize());
        }
        ctxStatusService.save(realHash, ctxStatusPO, chain.getChainId());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean crossTransferLocalByzantine(Chain chain, Transaction ctx, TransactionSignature signature, NulsHash realHash) throws NulsException, IOException {
        ArrayList<String> handleAddressList;
        BlockHeader blockheader = chainManager.getChainHeaderMap().get(chain.getChainId());
        if (null == blockheader) {
            chain.getLogger().info("ChainHeaderMap get failed : {} -of- {}", new Object[]{chain.getChainId(), chainManager.getChainHeaderMap().size()});
        }
        long broadHeight = blockheader.getHeight();
        try {
            chain.getSwitchVerifierLock().readLock().lock();
            handleAddressList = new ArrayList<String>(chain.getVerifierList());
            if (broadHeight < chain.getLastChangeHeight()) {
                broadHeight = chain.getLastChangeHeight();
            }
        }
        finally {
            chain.getSwitchVerifierLock().readLock().unlock();
        }
        int agentCount = handleAddressList.size();
        int byzantineCount = CommonUtil.getByzantineCount(chain, agentCount);
        int signCount = signature.getSignersCount();
        CtxStatusPO ctxStatusPO = new CtxStatusPO(ctx, TxStatusEnum.UNCONFIRM.getStatus());
        if (signCount >= byzantineCount) {
            List<P2PHKSignature> misMatchSignList = CommonUtil.getMisMatchSigns(chain, signature, handleAddressList);
            signCount = signature.getSignersCount();
            if (signCount >= byzantineCount) {
                ctx.setTransactionSignature(signature.serialize());
                MessageUtil.saveCtxSendHeight(chain, broadHeight, ctx);
                chain.getLogger().info("Cross chain transaction completed by Byzantium, placed in the waiting queue for packaging, waiting for broadcast,Hash:{},sendHeight:{},txType:{}", new Object[]{ctx.getHash().toHex(), broadHeight, ctx.getType()});
                float overflow = (float)(agentCount - byzantineCount) * 0.05f;
                int fullByzantineCount = byzantineCount + (int)Math.ceil(overflow);
                if (fullByzantineCount > agentCount) {
                    fullByzantineCount = agentCount;
                }
                if (signCount >= fullByzantineCount) {
                    chain.getLogger().info("Cross chain transaction signature count reaches saturation signature count:{},ctxSet toCONFIRMEDStatus, this node will no longer process this transaction", new Object[]{signCount});
                    ctxStatusPO.setStatus(TxStatusEnum.CONFIRMED.getStatus());
                } else {
                    chain.getLogger().debug("Cross chain transaction signatures have reached the minimum number of signatures:{}, but to reach saturation signature count:{}This section will continue to process this transaction", new Object[]{signCount, fullByzantineCount});
                }
                ctxStatusService.save(realHash, ctxStatusPO, chain.getChainId());
                return true;
            }
            signature.getP2PHKSignatures().addAll(misMatchSignList);
            ctx.setTransactionSignature(signature.serialize());
        } else {
            ctx.setTransactionSignature(signature.serialize());
        }
        ctxStatusService.save(realHash, ctxStatusPO, chain.getChainId());
        return false;
    }

    public static boolean handleOtherChainCtx(Transaction ctx, Chain chain, int fromChainId) {
        NulsHash ctxHash = ctx.getHash();
        try {
            if (ctx.getType() == 60 && config.isMainNet()) {
                return false;
            }
            TransactionSignature signature = new TransactionSignature();
            signature.parse(ctx.getTransactionSignature(), 0);
            int verifierChainId = fromChainId;
            if (!config.isMainNet()) {
                verifierChainId = config.getMainChainId();
            }
            if (ctx.getType() == 10 || ctx.getType() == 26 ? !MessageUtil.handleOtherChainCrossTransferTx(chain, ctx, signature, verifierChainId) : (ctx.getType() == 24 ? !MessageUtil.handleOtherChainVerifierChangeTx(chain, ctx, signature, verifierChainId) : (ctx.getType() == 25 ? !MessageUtil.handleOtherChainVerifierInitTx(chain, ctx, signature, verifierChainId) : !MessageUtil.handleOtherChainCrossTx(chain, ctx, signature, verifierChainId)))) {
                return false;
            }
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return false;
        }
        convertHashService.save(ctxHash, ctxHash, chain.getChainId());
        return true;
    }

    private static boolean handleOtherChainVerifierInitTx(Chain chain, Transaction ctx, TransactionSignature signature, int verifierChainId) {
        int minPassCount;
        Set<String> verifierList;
        if (!config.isMainNet()) {
            verifierList = new HashSet<String>(Arrays.asList(config.getVerifiers().split(",")));
            minPassCount = verifierList.size() * config.getMainByzantineRatio() / 100;
            if (minPassCount == 0) {
                minPassCount = 1;
            }
        } else {
            ChainInfo chainInfo = chainManager.getChainInfo(verifierChainId);
            if (chainInfo == null) {
                chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
                return false;
            }
            verifierList = chainInfo.getVerifierList();
            minPassCount = chainInfo.getMinPassCount();
        }
        try {
            if (!MessageUtil.otherCtxSignValidate(chain, ctx, signature, verifierChainId, verifierList, minPassCount)) {
                chain.getLogger().error("Verifier initialization transaction signature Byzantine verification failed,hash:{}", new Object[]{ctx.getHash().toHex()});
                return false;
            }
            TransactionCall.sendTx(chain, RPCUtil.encode((byte[])ctx.serialize()));
            chain.getLogger().debug("The receiving chain initialization validator completes the transaction verification and sends it to the transaction module for processing,hash:{}", new Object[]{ctx.getHash().toHex()});
        }
        catch (NulsException | IOException e) {
            chain.getLogger().error((Exception)e);
            return false;
        }
        return true;
    }

    private static boolean handleOtherChainVerifierChangeTx(Chain chain, Transaction ctx, TransactionSignature signature, int verifierChainId) {
        ChainInfo chainInfo = chainManager.getChainInfo(verifierChainId);
        if (chainInfo == null) {
            chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
            return false;
        }
        VerifierChangeData verifierChangeData = new VerifierChangeData();
        HashSet<String> verifierList = new HashSet<String>(chainInfo.getVerifierList());
        try {
            boolean dataValid;
            verifierChangeData.parse(ctx.getTxData(), 0);
            boolean haveCancelVerifier = verifierChangeData.getCancelAgentList() != null && !verifierChangeData.getCancelAgentList().isEmpty();
            boolean bl = dataValid = haveCancelVerifier || verifierChangeData.getRegisterAgentList() != null && !verifierChangeData.getRegisterAgentList().isEmpty();
            if (!dataValid) {
                chain.getLogger().error("Abnormal change of transaction data of verifier: there is no changed verifier");
                return false;
            }
            if (haveCancelVerifier) {
                int maxCancelCount = chainInfo.getVerifierList().size() * 30 / 100;
                if (verifierChangeData.getCancelAgentList().size() > maxCancelCount) {
                    chain.getLogger().error("Abnormal change of transaction data of verifier: the verifier who exits is more than 30%,cancelCount:{},maxCancelCount:{},totalCount:{}", new Object[]{verifierChangeData.getCancelAgentList().size(), maxCancelCount, chainInfo.getVerifierList().size()});
                    return false;
                }
                verifierList.removeAll(verifierChangeData.getCancelAgentList());
            }
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
            return false;
        }
        int minPassCount = chainInfo.getMinPassCount(verifierList.size());
        try {
            if (!MessageUtil.otherCtxSignValidate(chain, ctx, signature, verifierChainId, verifierList, minPassCount)) {
                chain.getLogger().error("Verifier changed transaction signature Byzantine verification failed,hash:{}", new Object[]{ctx.getHash().toHex()});
                return false;
            }
            TransactionCall.sendTx(chain, RPCUtil.encode((byte[])ctx.serialize()));
            chain.getLogger().debug("Verifier change transaction verification completed, sent to the transaction module for processing,hash:{}", new Object[]{ctx.getHash().toHex()});
        }
        catch (NulsException | IOException e) {
            chain.getLogger().error((Exception)e);
            return false;
        }
        return true;
    }

    private static boolean handleOtherChainCrossTransferTx(Chain chain, Transaction ctx, TransactionSignature signature, int verifierChainId) {
        ChainInfo chainInfo = chainManager.getChainInfo(verifierChainId);
        if (chainInfo == null) {
            chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
            return false;
        }
        Set<String> verifierList = chainInfo.getVerifierList();
        int minPassCount = chainInfo.getMinPassCount();
        try {
            if (!MessageUtil.otherCtxSignValidate(chain, ctx, signature, verifierChainId, verifierList, minPassCount)) {
                chain.getLogger().error("Cross chain transfer transaction signature Byzantine verification failed,hash:{}", new Object[]{ctx.getHash().toHex()});
                return false;
            }
            CoinData coinData = ctx.getCoinDataInstance();
            int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
            Transaction packCtx = ctx;
            String crossTxHashHex = ctx.getHash().toHex();
            if (chain.getChainId() == toChainId) {
                if (!config.isMainNet()) {
                    packCtx = TxUtil.mainConvertToFriend(ctx, config.getCrossCtxType());
                    packCtx.setTransactionSignature(signature.serialize());
                    convertCtxService.save(packCtx.getHash(), ctx, chain.getChainId());
                    chain.getLogger().info("Received main network protocol cross chain transactionshash\uff1a{}Corresponding cross chain transactions of this chain protocolhash:{}", new Object[]{crossTxHashHex, packCtx.getHash().toHex()});
                }
            } else if (!config.isMainNet()) {
                chain.getLogger().error("Cross chain transaction verification failed,hash:{}", new Object[]{crossTxHashHex});
                return false;
            }
            TransactionCall.sendTx(chain, RPCUtil.encode((byte[])packCtx.serialize()));
            chain.getLogger().info("The cross chain transfer transaction verification is completed and sent to the transaction module for processing,hash:{}", new Object[]{crossTxHashHex});
        }
        catch (NulsException | IOException e) {
            chain.getLogger().error((Exception)e);
            return false;
        }
        return true;
    }

    private static boolean handleOtherChainCrossTx(Chain chain, Transaction ctx, TransactionSignature signature, int verifierChainId) {
        ChainInfo chainInfo = chainManager.getChainInfo(verifierChainId);
        if (chainInfo == null) {
            chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
            return false;
        }
        Set<String> verifierList = chainInfo.getVerifierList();
        int minPassCount = chainInfo.getMinPassCount();
        try {
            String crossTxHashHex = ctx.getHash().toHex();
            if (!MessageUtil.otherCtxSignValidate(chain, ctx, signature, verifierChainId, verifierList, minPassCount)) {
                chain.getLogger().error("Cross chain transaction verification failed for other broadcasts,hash:{},txType:{}", new Object[]{crossTxHashHex, ctx.getType()});
                return false;
            }
            TransactionCall.sendTx(chain, RPCUtil.encode((byte[])ctx.serialize()));
            chain.getLogger().debug("The cross chain transaction verification for other broadcasts is completed and sent to the transaction module for processing,hash:{},txType:{}", new Object[]{crossTxHashHex, ctx.getType()});
        }
        catch (NulsException | IOException e) {
            chain.getLogger().error((Exception)e);
            return false;
        }
        return true;
    }

    private static boolean otherCtxSignValidate(Chain chain, Transaction ctx, TransactionSignature signature, int verifierChainId, Set<String> verifierList, int minPassCount) throws NulsException {
        if (verifierList == null || verifierList.isEmpty()) {
            chain.getLogger().error("The chain has not registered a verifier yet,chainId:{}", new Object[]{verifierChainId});
            return false;
        }
        int passCount = 0;
        List signatureList = signature.getP2PHKSignatures();
        if (signatureList == null || signatureList.size() < minPassCount) {
            chain.getLogger().error("The number of cross chain transaction signatures is less than the minimum number of Byzantine verifications,signCount{},minPassCount{}", new Object[]{signatureList == null ? 0 : signatureList.size(), minPassCount});
            try {
                chain.getLogger().error(HexUtil.encode((byte[])ctx.serialize()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        byte[] hashByte = ctx.getHash().getBytes();
        HashSet<String> passedAddress = new HashSet<String>();
        block2: for (P2PHKSignature sign : signatureList) {
            if (!SignatureUtil.validateSignture((byte[])hashByte, (P2PHKSignature)sign)) continue;
            for (String verifier : verifierList) {
                if (passedAddress.contains(verifier) || !Arrays.equals(AddressTool.getAddress((byte[])sign.getPublicKey(), (int)verifierChainId), AddressTool.getAddress((String)verifier))) continue;
                passedAddress.add(verifier);
                ++passCount;
                continue block2;
            }
        }
        if (passCount < minPassCount) {
            chain.getLogger().error("The number of signature verifications passed is less than the minimum number of Byzantine verifications,passCount:{},minPassCount:{}", new Object[]{passCount, minPassCount});
            return false;
        }
        chain.getLogger().info("Signature verification passed,passCount:{},minPassCount:{}, of: {}", new Object[]{passCount, minPassCount, ctx.getHash().toHex()});
        return true;
    }

    public static void broadcastCtx(Chain chain, NulsHash hash, int chainId, String nativeHex) {
        if (chain.getWaitBroadSignMap().get(hash) != null) {
            Iterator<WaitBroadSignMessage> iterator = chain.getWaitBroadSignMap().get(hash).iterator();
            HashSet<BroadCtxSignMessage> broadMessageSet = new HashSet<BroadCtxSignMessage>();
            while (iterator.hasNext()) {
                WaitBroadSignMessage waitBroadSignMessage = iterator.next();
                BroadCtxSignMessage message = waitBroadSignMessage.getMessage();
                String node = waitBroadSignMessage.getNodeId();
                if (!broadMessageSet.contains((Object)message)) {
                    if (!NetWorkCall.broadcast(chainId, message, node, "recvCtxSign", false)) continue;
                    iterator.remove();
                    String signStr = "";
                    if (message.getSignature() != null) {
                        signStr = HexUtil.encode((byte[])message.getSignature());
                    }
                    chain.getLogger().info("Broadcast cross chain transaction signatures to other nodes in the chain,hash:{},sign:{}", new Object[]{nativeHex, signStr});
                    broadMessageSet.add(message);
                    continue;
                }
                iterator.remove();
            }
            if (chain.getWaitBroadSignMap().get(hash).isEmpty()) {
                chain.getWaitBroadSignMap().remove(hash);
            }
        }
    }

    public static byte canSendMessage(Chain chain, int toChainId) {
        try {
            int minNodeAmount = chain.getConfig().getMinNodeAmount();
            boolean chainExist = false;
            for (ChainInfo chainInfo : chainManager.getRegisteredCrossChainList()) {
                if (chainInfo.getChainId() != toChainId) continue;
                if (config.isMainNet()) {
                    minNodeAmount = chainInfo.getMinAvailableNodeNum();
                }
                chainExist = true;
                break;
            }
            if (!chainExist) {
                return 0;
            }
            int linkedNode = NetWorkCall.getAvailableNodeAmount(toChainId, true);
            if (linkedNode >= minNodeAmount) {
                return 2;
            }
            chain.getLogger().debug("The number of cross chain nodes that the current node is linked to is less than the minimum number of links,crossChainId:{},linkedNodeCount:{},minLinkedCount:{}", new Object[]{toChainId, linkedNode, minNodeAmount});
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
        }
        return 1;
    }

    public static synchronized void saveCtxSendHeight(Chain chain, long sendHeight, Transaction ctx) {
        SendCtxHashPO sendCtxHashPo = sendHeightService.get(sendHeight, chain.getChainId());
        if (sendCtxHashPo == null) {
            ArrayList<NulsHash> hashList = new ArrayList<NulsHash>();
            hashList.add(ctx.getHash());
            sendCtxHashPo = new SendCtxHashPO(hashList);
        } else {
            sendCtxHashPo.getHashList().add(ctx.getHash());
        }
        sendHeightService.save(sendHeight, sendCtxHashPo, chain.getChainId());
    }
}

