/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.manager;

import io.nuls.base.data.BlockHeader;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.base.service.ResetLocalVerifierService;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.CmdRegisterDto;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.rpc.call.SmartContractCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.LoggerUtil;
import io.nuls.crosschain.utils.manager.LocalVerifierManager;
import io.nuls.crosschain.utils.thread.handler.GetCtxStateHandler;
import io.nuls.crosschain.utils.thread.handler.HashMessageHandler;
import io.nuls.crosschain.utils.thread.handler.OtherCtxMessageHandler;
import io.nuls.crosschain.utils.thread.handler.SaveCtxFullSignHandler;
import io.nuls.crosschain.utils.thread.handler.SignMessageByzantineHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class ChainManager {
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private RegisteredCrossChainService registeredCrossChainService;
    @Autowired
    CtxStatusService ctxStatusService;
    @Autowired
    private static ResetLocalVerifierService resetLocalVerifierService;
    @Autowired
    private ConvertCtxService convertCtxService;
    private Map<Integer, Chain> chainMap = new ConcurrentHashMap<Integer, Chain>();
    private List<ChainInfo> registeredCrossChainList = new ArrayList<ChainInfo>();
    private Map<Integer, BlockHeader> chainHeaderMap = new ConcurrentHashMap<Integer, BlockHeader>();
    private boolean crossNetUseAble = false;

    public void initChain() throws Exception {
        Map<Integer, ConfigBean> configMap = this.configChain();
        if (configMap == null || configMap.size() == 0) {
            Log.info((String)"Chain initialization failed\uff01");
            return;
        }
        for (Map.Entry<Integer, ConfigBean> entry : configMap.entrySet()) {
            Chain chain = new Chain();
            int chainId = entry.getKey();
            ConfigBean configBean = entry.getValue();
            if (chainId == this.config.getMainChainId() && configBean.getAssetId() == this.config.getMainAssetId()) {
                this.config.setMainNet(true);
                chain.setMainChain(true);
            }
            chain.setConfig(configBean);
            LoggerUtil.initLogger(chain);
            this.initTable(chain);
            this.chainMap.put(chainId, chain);
        }
        if (!this.config.isMainNet()) {
            RegisteredChainMessage registeredChainMessage = this.registeredCrossChainService.get();
            if (registeredChainMessage != null) {
                this.registeredCrossChainList = registeredChainMessage.getChainInfoList();
                this.crossNetUseAble = true;
            } else {
                ChainInfo mainChainInfo = new ChainInfo();
                mainChainInfo.setVerifierList(new HashSet<String>(Arrays.asList(this.config.getVerifiers().split(","))));
                mainChainInfo.setMaxSignatureCount(this.config.getMaxSignatureCount());
                mainChainInfo.setSignatureByzantineRatio(this.config.getMainByzantineRatio());
                mainChainInfo.setChainId(this.config.getMainChainId());
                this.registeredCrossChainList.add(mainChainInfo);
            }
        }
    }

    public void registerContractTx() {
        for (Chain chain : this.chainMap.values()) {
            int chainId = chain.getConfig().getChainId();
            ArrayList<CmdRegisterDto> cmdRegisterDtoList = new ArrayList<CmdRegisterDto>();
            CmdRegisterDto tokenOutCrossChain = new CmdRegisterDto("cc_tokenOutCrossChain", 0, List.of("from", "to", "value"), 1);
            cmdRegisterDtoList.add(tokenOutCrossChain);
            SmartContractCall.registerContractTx(chainId, cmdRegisterDtoList);
        }
    }

    public void runChain() {
        for (Chain chain : this.chainMap.values()) {
            LocalVerifierManager.loadLocalVerifier(chain);
            chain.setSyncStatus(BlockCall.getBlockStatus(chain));
            chain.getThreadPool().execute(new HashMessageHandler(chain));
            chain.getThreadPool().execute(new OtherCtxMessageHandler(chain));
            chain.getThreadPool().execute(new GetCtxStateHandler(chain));
            chain.getThreadPool().execute(new SignMessageByzantineHandler(chain));
            chain.getThreadPool().execute(new SaveCtxFullSignHandler(chain, this.config, this.ctxStatusService, resetLocalVerifierService, this.convertCtxService));
            int syncStatus = BlockCall.getBlockStatus(chain);
            chain.getLogger().info("The current status of the node is:{}", new Object[]{syncStatus});
            chain.setSyncStatus(syncStatus);
        }
        if (this.config.isMainNet()) {
            this.crossNetUseAble = true;
        }
    }

    private Map<Integer, ConfigBean> configChain() {
        try {
            HashMap<Integer, ConfigBean> configMap = new HashMap<Integer, ConfigBean>();
            if (configMap == null || configMap.size() == 0) {
                NulsCoresConfig configBean = this.config;
                if (this.config.getVerifiers() != null) {
                    configBean.setVerifierSet(new HashSet<String>(Arrays.asList(this.config.getVerifiers().split(","))));
                } else {
                    configBean.setVerifierSet(new HashSet<String>());
                }
                configMap.put(((ConfigBean)configBean).getChainId(), configBean);
            }
            return configMap;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    private void initTable(Chain chain) {
        int chainId = chain.getConfig().getChainId();
        try {
            RocksDBService.createTable((String)("new_ctx_status" + chainId));
            RocksDBService.createTable((String)("convert_ctx" + chainId));
            RocksDBService.createTable((String)("convert_hash_ctx" + chainId));
            RocksDBService.createTable((String)("commit_other_ctx" + chainId));
            RocksDBService.createTable((String)("send_height" + chainId));
            RocksDBService.createTable((String)("sended_height" + chainId));
            RocksDBService.createTable((String)("ctx_state" + chainId));
            RocksDBService.createTable((String)("verifier_broad_fail" + chainId));
            RocksDBService.createTable((String)("cross_change_broad_fail" + chainId));
            RocksDBService.createTable((String)("old_local_verifier" + chainId));
        }
        catch (Exception e) {
            LoggerUtil.commonLog.error(e.getMessage());
        }
    }

    public Map<Integer, Chain> getChainMap() {
        return this.chainMap;
    }

    public void setChainMap(Map<Integer, Chain> chainMap) {
        this.chainMap = chainMap;
    }

    public List<ChainInfo> getRegisteredCrossChainList() {
        return this.registeredCrossChainList;
    }

    public void setRegisteredCrossChainList(List<ChainInfo> registeredCrossChainList) {
        this.registeredCrossChainList = registeredCrossChainList;
    }

    public boolean isCrossNetUseAble() {
        return this.crossNetUseAble;
    }

    public void setCrossNetUseAble(boolean crossNetUseAble) {
        this.crossNetUseAble = crossNetUseAble;
    }

    public Map<Integer, BlockHeader> getChainHeaderMap() {
        return this.chainHeaderMap;
    }

    public void setChainHeaderMap(Map<Integer, BlockHeader> chainHeaderMap) {
        this.chainHeaderMap = chainHeaderMap;
    }

    public ChainInfo getChainInfo(int fromChainId) {
        for (ChainInfo chainInfo : this.registeredCrossChainList) {
            if (chainInfo.getChainId() != fromChainId) continue;
            return chainInfo;
        }
        return null;
    }

    public List<Map<String, Object>> getPrefixList() {
        ArrayList<Map<String, Object>> chainPrefixList = new ArrayList<Map<String, Object>>();
        for (ChainInfo chainInfo : this.registeredCrossChainList) {
            HashMap<String, Object> prefixMap = new HashMap<String, Object>(2);
            prefixMap.put("chainId", chainInfo.getChainId());
            prefixMap.put("addressPrefix", chainInfo.getAddressPrefix());
            chainPrefixList.add(prefixMap);
        }
        return chainPrefixList;
    }
}

