/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.thread.handler;

import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.utils.MessageUtil;

public class HashMessageHandler
implements Runnable {
    private Chain chain;

    public HashMessageHandler(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void run() {
        while (this.chain.getHashMessageQueue() != null) {
            try {
                UntreatedMessage untreatedMessage = this.chain.getHashMessageQueue().take();
                String nativeHex = untreatedMessage.getCacheHash().toHex();
                this.chain.getLogger().info("Start processing other chain nodes{}Cross chain transactions broadcasted overHashnews,Hash\uff1a{}", new Object[]{untreatedMessage.getNodeId(), nativeHex});
                MessageUtil.handleNewHashMessage(this.chain, untreatedMessage.getCacheHash(), untreatedMessage.getChainId(), untreatedMessage.getNodeId(), nativeHex);
            }
            catch (Exception e) {
                this.chain.getLogger().error(e);
            }
        }
    }
}

