/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.thread.handler;

import io.nuls.base.data.NulsHash;
import io.nuls.crosschain.base.message.GetOtherCtxMessage;
import io.nuls.crosschain.base.message.NewOtherCtxMessage;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.NodeType;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.utils.MessageUtil;

public class OtherCtxMessageHandler
implements Runnable {
    private Chain chain;

    public OtherCtxMessageHandler(Chain chain) {
        this.chain = chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.chain.getOtherCtxMessageQueue() != null) {
            NulsHash otherHash = null;
            try {
                UntreatedMessage untreatedMessage = this.chain.getOtherCtxMessageQueue().take();
                NewOtherCtxMessage messageBody = (NewOtherCtxMessage)untreatedMessage.getMessage();
                otherHash = untreatedMessage.getCacheHash();
                String otherHex = otherHash.toHex();
                int fromChainId = untreatedMessage.getChainId();
                this.chain.getLogger().info("Start processing other chain nodes\uff1a{}Cross chain transactions sent,Hash:{}", new Object[]{untreatedMessage.getNodeId(), otherHex});
                boolean handleResult = MessageUtil.handleOtherChainCtx(messageBody.getCtx(), this.chain, fromChainId);
                if (!handleResult && this.chain.getOtherHashNodeIdMap().get(otherHash) != null && !this.chain.getOtherHashNodeIdMap().get(otherHash).isEmpty()) {
                    this.regainCtx(this.chain, fromChainId, otherHash, otherHex);
                }
                this.chain.getLogger().info("New transaction processing completed,Hash:{}\n\n", new Object[]{otherHex});
                if (otherHash == null) continue;
                this.chain.getOtherCtxStageMap().remove(otherHash);
            }
            catch (Exception e) {
                try {
                    this.chain.getLogger().error(e);
                    if (otherHash == null) continue;
                    this.chain.getOtherCtxStageMap().remove(otherHash);
                }
                catch (Throwable throwable) {
                    if (otherHash != null) {
                        this.chain.getOtherCtxStageMap().remove(otherHash);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void regainCtx(Chain chain, int chainId, NulsHash cacheHash, String nativeHex) {
        NodeType nodeType = chain.getOtherHashNodeIdMap().get(cacheHash).remove(0);
        if (chain.getOtherHashNodeIdMap().get(cacheHash).isEmpty()) {
            chain.getOtherHashNodeIdMap().remove(cacheHash);
        }
        GetOtherCtxMessage responseMessage = new GetOtherCtxMessage();
        responseMessage.setRequestHash(cacheHash);
        NetWorkCall.sendToNode(chainId, responseMessage, nodeType.getNodeId(), "getOtherCtx");
        chain.getLogger().info("Cross chain transaction processing failed, sending to other chain nodes\uff1a{}Retrieve cross chain transactions again,Hash:{}", new Object[]{nodeType.getNodeId(), nativeHex});
    }
}

