/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.ChainManagerCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Component
public class CrossTxValidator {
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private ConvertHashService convertHashService;
    @Autowired
    private ConvertCtxService convertCtxService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    RegisteredCrossChainService registeredCrossChainService;

    public boolean validateTx(Chain chain, Transaction tx, BlockHeader blockHeader) throws NulsException, IOException {
        CoinData coinData = tx.getCoinDataInstance();
        int fromChainId = AddressTool.getChainIdByAddress((byte[])((CoinFrom)coinData.getFrom().get(0)).getAddress());
        int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)coinData.getTo().get(0)).getAddress());
        if (ProtocolGroupManager.getCurrentVersion((int)chain.getChainId()) >= 18 && coinData.getTo().size() != 1) {
            throw new NulsException(NulsCrossChainErrorCode.TO_ADDRESS_ERROR);
        }
        chain.getLogger().info("Cross chain tx : {}", new Object[]{tx.getHash().toHex()});
        if (toChainId == 0) {
            throw new NulsException(NulsCrossChainErrorCode.TO_ADDRESS_ERROR);
        }
        if (chain.getChainId() == fromChainId) {
            if (tx.getType() == 10) {
                for (CoinFrom from : coinData.getFrom()) {
                    if (!AddressTool.validContractAddress((byte[])from.getAddress(), (int)AddressTool.getChainIdByAddress((byte[])from.getAddress())) && this.registeredCrossChainService.canCross(from.getAssetsChainId(), from.getAssetsId())) continue;
                }
                if (!this.coinDataValid(chain, coinData, tx.size())) {
                    throw new NulsException(NulsCrossChainErrorCode.COINDATA_VERIFY_FAIL);
                }
                Set fromAddressSet = tx.getCoinDataInstance().getFromAddressList();
                TransactionSignature transactionSignature = new TransactionSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                boolean verifyResult = false;
                byte[] txHashByte = tx.getHash().getBytes();
                for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
                    if (!ECKey.verify((byte[])txHashByte, (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) {
                        chain.getLogger().error("Signature verification failed");
                        throw new NulsException((Throwable)new Exception("Transaction signature error !"));
                    }
                    String signAddress = AddressTool.getStringAddressByBytes((byte[])AddressTool.getAddress((byte[])signature.getPublicKey(), (int)chain.getChainId()));
                    fromAddressSet.remove(signAddress);
                    if (!fromAddressSet.isEmpty()) continue;
                    verifyResult = true;
                    break;
                }
                if (!verifyResult) {
                    throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
                }
            }
        } else {
            ChainInfo chainInfo;
            int validateTxSize = tx.size() - SerializeUtils.sizeOfBytes((byte[])tx.getTransactionSignature());
            if (!this.coinDataValid(chain, coinData, validateTxSize)) {
                throw new NulsException(NulsCrossChainErrorCode.COINDATA_VERIFY_FAIL);
            }
            Transaction realCtx = tx;
            int verifierChainId = fromChainId;
            if (chain.getChainId() == toChainId && !this.config.isMainNet()) {
                verifierChainId = this.config.getMainChainId();
                int txType = 10;
                if (tx.getTxData() != null) {
                    txType = ByteUtils.bytesToInt((byte[])tx.getTxData());
                }
                realCtx = TxUtil.friendConvertToMain(chain, tx, txType, true);
            }
            if ((chainInfo = this.chainManager.getChainInfo(verifierChainId)) == null) {
                chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
                throw new NulsException(NulsCrossChainErrorCode.CHAIN_UNREGISTERED);
            }
            ArrayList<String> verifierList = new ArrayList<String>(chainInfo.getVerifierList());
            if (verifierList.isEmpty()) {
                chain.getLogger().error("The chain has not registered a verifier yet,chainId:{}", new Object[]{verifierChainId});
                throw new NulsException(NulsCrossChainErrorCode.CHAIN_UNREGISTERED_VERIFIER);
            }
            int minPassCount = chainInfo.getMinPassCount();
            if (!SignatureUtil.validateCtxSignture((Transaction)realCtx)) {
                chain.getLogger().info("Main network protocol cross chain transaction signature verification failed\uff01");
                throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
            }
            if (!TxUtil.signByzantineVerify(chain, realCtx, verifierList, minPassCount, verifierChainId)) {
                chain.getLogger().info("Signature Byzantine verification failed\uff01");
                throw new NulsException(NulsCrossChainErrorCode.CTX_SIGN_BYZANTINE_FAIL);
            }
        }
        if (this.config.isMainNet() && !ChainManagerCall.verifyCtxAsset(fromChainId, tx)) {
            chain.getLogger().info("Cross chain asset verification failed\uff01");
            throw new NulsException(NulsCrossChainErrorCode.CROSS_ASSERT_VALID_ERROR);
        }
        return true;
    }

    public boolean coinDataValid(Chain chain, CoinData coinData, int txSize) throws NulsException {
        return this.coinDataValid(chain, coinData, txSize, true);
    }

    public boolean coinDataValid(Chain chain, CoinData coinData, int txSize, boolean isLocalCtx) throws NulsException {
        List coinFromList = coinData.getFrom();
        List coinToList = coinData.getTo();
        if (coinFromList == null || coinFromList.isEmpty() || coinToList == null || coinToList.isEmpty()) {
            chain.getLogger().error("The transferor or transferee is empty");
            throw new NulsException(NulsCrossChainErrorCode.COINFROM_NOT_FOUND);
        }
        int fromChainId = 0;
        int toChainId = 0;
        for (CoinFrom coinFrom : coinFromList) {
            if (fromChainId == 0) {
                fromChainId = AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress());
            }
            if (AddressTool.getChainIdByAddress((byte[])coinFrom.getAddress()) == fromChainId) continue;
            chain.getLogger().error("The transferor of cross chain transactions has multiple chain accounts");
            throw new NulsException(NulsCrossChainErrorCode.CROSS_TX_PAYER_CHAIN_NOT_SAME);
        }
        for (CoinTo coinTo : coinToList) {
            if (toChainId == 0) {
                toChainId = AddressTool.getChainIdByAddress((byte[])coinTo.getAddress());
            }
            if (AddressTool.getChainIdByAddress((byte[])coinTo.getAddress()) == toChainId) continue;
            chain.getLogger().error("Cross chain transaction transferee has multiple chain accounts");
            throw new NulsException(NulsCrossChainErrorCode.CROSS_TX_PAYEE_CHAIN_NOT_SAME);
        }
        if (fromChainId == toChainId) {
            chain.getLogger().error("The transferor and transferee of cross chain transactions are the same chain account");
            throw new NulsException(NulsCrossChainErrorCode.PAYEE_AND_PAYER_IS_THE_SAME_CHAIN);
        }
        int chainId = chain.getChainId();
        if (fromChainId != chainId && toChainId != chainId && !this.config.isMainNet()) {
            chain.getLogger().error("This cross chain transaction is not a local cross chain transaction");
            throw new NulsException(NulsCrossChainErrorCode.NOT_BELONG_TO_CURRENT_CHAIN);
        }
        if (chain.getChainId() != fromChainId || !isLocalCtx) {
            BigInteger feeTotalFrom = BigInteger.ZERO;
            for (Object coinFrom : coinFromList) {
                if (!CommonUtil.isNulsAsset((Coin)coinFrom)) continue;
                feeTotalFrom = feeTotalFrom.add(coinFrom.getAmount());
            }
            BigInteger feeTotalTo = BigInteger.ZERO;
            for (CoinTo coinTo : coinToList) {
                if (!CommonUtil.isNulsAsset((Coin)coinTo)) continue;
                feeTotalTo = feeTotalTo.add(coinTo.getAmount());
            }
            BigInteger targetFee = TransactionFeeCalculator.getCrossTxFee((int)txSize);
            BigInteger actualFee = feeTotalFrom.subtract(feeTotalTo);
            if (BigIntegerUtils.isLessThan((BigInteger)actualFee, (BigInteger)targetFee)) {
                chain.getLogger().error("Insufficient handling fees");
                throw new NulsException(NulsCrossChainErrorCode.INSUFFICIENT_FEE);
            }
        }
        return true;
    }
}

