/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model;

import io.nuls.core.constant.ErrorCode;
import io.nuls.ledger.constant.LedgerErrorCode;
import java.util.HashMap;
import java.util.Map;

public class ValidateResult {
    public static final String VALIDATE_SUCCESS_DESC = "success";
    public static final String VALIDATE_ORPHAN_DESC = "address {%s},nonce {%s}!={%s} is orphan transaction";
    public static final String VALIDATE_DOUBLE_EXPENSES_DESC = "address {%s},nonce {%s} is double expenses";
    public static final String VALIDATE_FAIL_DESC = "address {%s},nonce {%s} validate fail:{%s}";
    public static final String VALIDATE_TX_EXIST_DESC = "address={%s},hash={%s} in packing";
    public static final String BALANCE_NOT_ENOUGH_DESC = "assetKey={%s}, balance={%s},balance is not enough";
    public static final String TX_AMOUNT_ERROR_DESC = "tx={%s} from amounts is less than to";
    public static Map<ErrorCode, ValidateResult> validateResultMap = new HashMap<ErrorCode, ValidateResult>(6);
    private ErrorCode validateCode;
    private String validateDesc;

    public ValidateResult(ErrorCode validateCode, String validateDesc) {
        this.validateCode = validateCode;
        this.validateDesc = validateDesc;
    }

    public static ValidateResult getValidateResult(ErrorCode validateCode, String validateDesc) {
        return new ValidateResult(validateCode, validateDesc);
    }

    public static ValidateResult getResult(ErrorCode errorCode, String[] args) {
        return new ValidateResult(errorCode, String.format(ValidateResult.validateResultMap.get((Object)errorCode).validateDesc, args));
    }

    public static ValidateResult getSuccess() {
        return validateResultMap.get(LedgerErrorCode.SUCCESS);
    }

    public ErrorCode getValidateCode() {
        return this.validateCode;
    }

    public void setValidateCode(ErrorCode validateCode) {
        this.validateCode = validateCode;
    }

    public String getValidateDesc() {
        return this.validateDesc;
    }

    public void setValidateDesc(String validateDesc) {
        this.validateDesc = validateDesc;
    }

    public boolean isSuccess() {
        return this.validateCode.getCode().equals(LedgerErrorCode.SUCCESS.getCode());
    }

    public boolean isOrphan() {
        return this.validateCode.getCode().equals(LedgerErrorCode.ORPHAN.getCode());
    }

    public ErrorCode toErrorCode() {
        return this.validateCode;
    }

    static {
        validateResultMap.put(LedgerErrorCode.SUCCESS, ValidateResult.getValidateResult(LedgerErrorCode.SUCCESS, VALIDATE_SUCCESS_DESC));
        validateResultMap.put(LedgerErrorCode.ORPHAN, ValidateResult.getValidateResult(LedgerErrorCode.ORPHAN, VALIDATE_ORPHAN_DESC));
        validateResultMap.put(LedgerErrorCode.DOUBLE_EXPENSES, ValidateResult.getValidateResult(LedgerErrorCode.DOUBLE_EXPENSES, VALIDATE_DOUBLE_EXPENSES_DESC));
        validateResultMap.put(LedgerErrorCode.VALIDATE_FAIL, ValidateResult.getValidateResult(LedgerErrorCode.VALIDATE_FAIL, VALIDATE_FAIL_DESC));
        validateResultMap.put(LedgerErrorCode.TX_EXIST, ValidateResult.getValidateResult(LedgerErrorCode.TX_EXIST, VALIDATE_TX_EXIST_DESC));
        validateResultMap.put(LedgerErrorCode.BALANCE_NOT_ENOUGH, ValidateResult.getValidateResult(LedgerErrorCode.BALANCE_NOT_ENOUGH, BALANCE_NOT_ENOUGH_DESC));
        validateResultMap.put(LedgerErrorCode.TX_AMOUNT_INVALIDATE, ValidateResult.getValidateResult(LedgerErrorCode.TX_AMOUNT_INVALIDATE, TX_AMOUNT_ERROR_DESC));
    }
}

