/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po;

import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.model.po.TxUnconfirmed;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccountStateUnconfirmed {
    private byte[] fromNonce = LedgerConstant.getInitNonceByte();
    private byte[] nonce = LedgerConstant.getInitNonceByte();
    private BigInteger toConfirmedAmount = BigInteger.ZERO;
    private BigInteger unconfirmedAmount = BigInteger.ZERO;
    Map<String, TxUnconfirmed> txUnconfirmedMap = new ConcurrentHashMap<String, TxUnconfirmed>();
    private long createTime = 0L;

    public AccountStateUnconfirmed() {
    }

    public Map<String, TxUnconfirmed> getTxUnconfirmedMap() {
        return this.txUnconfirmedMap;
    }

    public void setTxUnconfirmedMap(Map<String, TxUnconfirmed> txUnconfirmedMap) {
        this.txUnconfirmedMap = txUnconfirmedMap;
    }

    public void addTxUnconfirmed(String nonce, TxUnconfirmed txUnconfirmed) {
        this.txUnconfirmedMap.put(nonce, txUnconfirmed);
    }

    public void addTxUnconfirmeds(Map<String, TxUnconfirmed> txUnconfirmeds) {
        this.txUnconfirmedMap.putAll(txUnconfirmeds);
    }

    public TxUnconfirmed getTxUnconfirmed(String nonce) {
        return this.txUnconfirmedMap.get(nonce);
    }

    public void delTxUnconfirmed(String nonce) {
        this.txUnconfirmedMap.remove(nonce);
    }

    public void clearTxUnconfirmeds() {
        this.txUnconfirmedMap.clear();
    }

    public AccountStateUnconfirmed(byte[] pFromNonce, byte[] pNonce, BigInteger amount) {
        System.arraycopy(pFromNonce, 0, this.fromNonce, 0, 8);
        System.arraycopy(pNonce, 0, this.nonce, 0, 8);
        this.unconfirmedAmount = amount;
        this.createTime = NulsDateUtils.getCurrentTimeSeconds();
    }

    public byte[] getFromNonce() {
        return this.fromNonce;
    }

    public void setFromNonce(byte[] fromNonce) {
        this.fromNonce = fromNonce;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public BigInteger getAmount() {
        BigInteger unconfirmed = this.unconfirmedAmount.subtract(this.toConfirmedAmount);
        if (BigIntegerUtils.isLessThan((BigInteger)unconfirmed, (BigInteger)BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        return unconfirmed;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public boolean isOverTime() {
        return NulsDateUtils.getCurrentTimeSeconds() - this.createTime > (long)LedgerConstant.UNCONFIRM_NONCE_EXPIRED_TIME;
    }

    public BigInteger getToConfirmedAmount() {
        return this.toConfirmedAmount;
    }

    public void setToConfirmedAmount(BigInteger toConfirmedAmount) {
        this.toConfirmedAmount = toConfirmedAmount;
    }

    public BigInteger getUnconfirmedAmount() {
        return this.unconfirmedAmount;
    }

    public void setUnconfirmedAmount(BigInteger unconfirmedAmount) {
        this.unconfirmedAmount = unconfirmedAmount;
    }
}

