/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.ledger.model.po.sub.AccountStateSnapshot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BlockSnapshotAccounts
extends BaseNulsData {
    private List<AccountStateSnapshot> accounts = new ArrayList<AccountStateSnapshot>();

    public void addAccountState(AccountStateSnapshot accountState) {
        this.accounts.add(accountState);
    }

    public List<AccountStateSnapshot> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountStateSnapshot> accounts) {
        this.accounts = accounts;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.accounts.size());
        for (AccountStateSnapshot accountStateSnapshot : this.accounts) {
            stream.writeNulsData((BaseNulsData)accountStateSnapshot);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int accountsCount = byteBuffer.readUint16();
        for (int i = 0; i < accountsCount; ++i) {
            try {
                AccountStateSnapshot accountStateSnapshot = new AccountStateSnapshot();
                byteBuffer.readNulsData((BaseNulsData)accountStateSnapshot);
                this.accounts.add(accountStateSnapshot);
                continue;
            }
            catch (Exception e) {
                throw new NulsException((Throwable)e);
            }
        }
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        for (AccountStateSnapshot accountStateSnapshot : this.accounts) {
            size += accountStateSnapshot.size();
        }
        return size;
    }
}

