/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BlockSnapshotTxs
extends BaseNulsData {
    private List<String> txHashList = new ArrayList<String>();
    private List<String> addressNonceList = new ArrayList<String>();
    private String blockHash = "";

    public List<String> getTxHashList() {
        return this.txHashList;
    }

    public void setTxHashList(List<String> txHashList) {
        this.txHashList = txHashList;
    }

    public List<String> getAddressNonceList() {
        return this.addressNonceList;
    }

    public void setAddressNonceList(List<String> addressNonceList) {
        this.addressNonceList = addressNonceList;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public void addHash(String hash) {
        this.txHashList.add(hash);
    }

    public void addNonce(String addressNonce) {
        this.addressNonceList.add(addressNonce);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.blockHash);
        stream.writeUint16(this.txHashList.size());
        for (String hash : this.txHashList) {
            stream.writeString(hash);
        }
        stream.writeUint16(this.addressNonceList.size());
        for (String addressNonce : this.addressNonceList) {
            stream.writeString(addressNonce);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.blockHash = byteBuffer.readString();
        int hashCount = byteBuffer.readUint16();
        for (int i = 0; i < hashCount; ++i) {
            try {
                this.txHashList.add(byteBuffer.readString());
                continue;
            }
            catch (Exception e) {
                throw new NulsException((Throwable)e);
            }
        }
        int nonceCount = byteBuffer.readUint16();
        for (int i = 0; i < nonceCount; ++i) {
            try {
                this.addressNonceList.add(byteBuffer.readString());
                continue;
            }
            catch (Exception e) {
                throw new NulsException((Throwable)e);
            }
        }
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString((String)this.blockHash);
        size += SerializeUtils.sizeOfUint16();
        for (String hash : this.txHashList) {
            size += SerializeUtils.sizeOfString((String)hash);
        }
        size += SerializeUtils.sizeOfUint16();
        for (String addressNonce : this.addressNonceList) {
            size += SerializeUtils.sizeOfString((String)addressNonce);
        }
        return size;
    }
}

