/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.model.tx.txdata.TxLedgerAsset;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class LedgerAsset
extends BaseNulsData {
    private int chainId = 0;
    private int assetId = 0;
    private String symbol;
    private String assetName;
    private short assetType = 1;
    private BigInteger destroyNuls = BigInteger.ZERO;
    private BigInteger initNumber = BigInteger.ZERO;
    private short decimalPlace = (short)8;
    private byte[] assetOwnerAddress;
    private byte[] creatorAddress;
    private String txHash;
    private long createTime = 0L;

    public LedgerAsset(TxLedgerAsset tx, int chainId, BigInteger destroyNuls, String txHash, long createTime, byte[] creatorAddress, short assetType) {
        this.chainId = chainId;
        this.assetType = assetType;
        this.symbol = tx.getSymbol();
        this.assetName = tx.getName();
        this.destroyNuls = destroyNuls;
        this.initNumber = tx.getInitNumber();
        this.decimalPlace = tx.getDecimalPlace();
        this.assetOwnerAddress = tx.getAddress();
        this.creatorAddress = creatorAddress;
        this.txHash = txHash;
        this.createTime = createTime;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeUint8(this.assetType);
        stream.writeUint16(this.assetId);
        stream.writeString(this.symbol);
        stream.writeString(this.assetName);
        stream.writeBigInteger(this.destroyNuls);
        stream.writeBigInteger(this.initNumber);
        stream.writeUint8(this.decimalPlace);
        stream.writeBytesWithLength(this.assetOwnerAddress);
        stream.writeBytesWithLength(this.creatorAddress);
        stream.writeString(this.txHash);
        stream.writeUint32(this.createTime);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.assetType = byteBuffer.readUint8();
        this.assetId = byteBuffer.readUint16();
        this.symbol = byteBuffer.readString();
        this.assetName = byteBuffer.readString();
        this.destroyNuls = byteBuffer.readBigInteger();
        this.initNumber = byteBuffer.readBigInteger();
        this.decimalPlace = byteBuffer.readUint8();
        this.assetOwnerAddress = byteBuffer.readByLengthByte();
        this.creatorAddress = byteBuffer.readByLengthByte();
        this.txHash = byteBuffer.readString();
        this.createTime = byteBuffer.readUint32();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint8();
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfString((String)this.symbol);
        size += SerializeUtils.sizeOfString((String)this.assetName);
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfUint8();
        size += SerializeUtils.sizeOfBytes((byte[])this.assetOwnerAddress);
        size += SerializeUtils.sizeOfBytes((byte[])this.creatorAddress);
        size += SerializeUtils.sizeOfString((String)this.txHash);
        return size += SerializeUtils.sizeOfUint32();
    }

    public byte[] parseToTransaction() throws IOException {
        TxLedgerAsset txAsset = new TxLedgerAsset();
        txAsset.setName(this.getAssetName());
        txAsset.setInitNumber(this.getInitNumber());
        txAsset.setDecimalPlace(this.getDecimalPlace());
        txAsset.setSymbol(this.getSymbol());
        txAsset.setAddress(this.getAssetOwnerAddress());
        return txAsset.serialize();
    }

    public LedgerAsset() {
    }

    public void map2pojo(Map<String, Object> map, short assetType) {
        this.setChainId(Integer.valueOf(map.get("chainId").toString()));
        this.setAssetName(String.valueOf(map.get("assetName")));
        BigInteger initNumber = new BigInteger(String.valueOf(map.get("initNumber")));
        this.setInitNumber(initNumber);
        this.setDecimalPlace(Short.valueOf(map.get("decimalPlace").toString()));
        this.setSymbol(String.valueOf(map.get("assetSymbol")));
        this.setAssetOwnerAddress(AddressTool.getAddress((String)map.get("address").toString()));
        this.setCreateTime(NulsDateUtils.getCurrentTimeSeconds());
        this.assetType = assetType;
    }

    public Map<String, Object> toMap() {
        LedgerAsset asset = this;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (asset == null) {
            return result;
        }
        result.put("assetChainId", asset.getChainId());
        result.put("assetId", asset.getAssetId());
        result.put("initNumber", asset.getInitNumber());
        result.put("decimalPlace", asset.getDecimalPlace());
        result.put("assetName", asset.getAssetName());
        result.put("assetSymbol", asset.getSymbol());
        short assetType = asset.getAssetType();
        result.put("assetType", assetType);
        if (asset.getAssetOwnerAddress() != null) {
            String address = AddressTool.getStringAddressByBytes((byte[])asset.getAssetOwnerAddress());
            result.put("assetAddress", address);
        }
        return result;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public short getAssetType() {
        return this.assetType;
    }

    public void setAssetType(short assetType) {
        this.assetType = assetType;
    }

    public BigInteger getDestroyNuls() {
        return this.destroyNuls;
    }

    public void setDestroyNuls(BigInteger destroyNuls) {
        this.destroyNuls = destroyNuls;
    }

    public BigInteger getInitNumber() {
        return this.initNumber;
    }

    public void setInitNumber(BigInteger initNumber) {
        this.initNumber = initNumber;
    }

    public short getDecimalPlace() {
        return this.decimalPlace;
    }

    public void setDecimalPlace(short decimalPlace) {
        this.decimalPlace = decimalPlace;
    }

    public byte[] getAssetOwnerAddress() {
        return this.assetOwnerAddress;
    }

    public void setAssetOwnerAddress(byte[] assetOwnerAddress) {
        this.assetOwnerAddress = assetOwnerAddress;
    }

    public byte[] getCreatorAddress() {
        return this.creatorAddress;
    }

    public void setCreatorAddress(byte[] creatorAddress) {
        this.creatorAddress = creatorAddress;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }
}

