/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po.sub;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.sub.AmountNonce;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AccountStateSnapshot
extends BaseNulsData {
    private String address;
    private int addressChainId;
    private int assetChainId;
    private int assetId;
    AccountState accountState;
    private List<AmountNonce> nonces = new ArrayList<AmountNonce>();

    public AccountStateSnapshot() {
    }

    public AccountStateSnapshot(int addressChainId, int assetChainId, int assetId, String address, AccountState accountState) {
        this.address = address;
        this.addressChainId = addressChainId;
        this.assetChainId = assetChainId;
        this.assetId = assetId;
        this.accountState = accountState;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.address);
        stream.writeUint16(this.addressChainId);
        stream.writeUint16(this.assetChainId);
        stream.writeUint16(this.assetId);
        stream.writeNulsData((BaseNulsData)this.accountState);
        stream.writeUint16(this.nonces.size());
        for (AmountNonce nonce : this.nonces) {
            stream.writeNulsData((BaseNulsData)nonce);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.address = byteBuffer.readString();
        this.addressChainId = byteBuffer.readUint16();
        this.assetChainId = byteBuffer.readUint16();
        this.assetId = byteBuffer.readUint16();
        AccountState accountState = new AccountState();
        byteBuffer.readNulsData((BaseNulsData)accountState);
        this.accountState = accountState;
        int nonceCount = byteBuffer.readUint16();
        for (int i = 0; i < nonceCount; ++i) {
            AmountNonce amountNonce = new AmountNonce();
            byteBuffer.readNulsData((BaseNulsData)amountNonce);
            this.nonces.add(amountNonce);
        }
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString((String)this.address);
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfNulsData((NulsData)this.accountState);
        size += SerializeUtils.sizeOfUint16();
        for (AmountNonce nonce : this.nonces) {
            size += SerializeUtils.sizeOfNulsData((NulsData)nonce);
        }
        return size;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getAddressChainId() {
        return this.addressChainId;
    }

    public void setAddressChainId(int addressChainId) {
        this.addressChainId = addressChainId;
    }

    public int getAssetChainId() {
        return this.assetChainId;
    }

    public void setAssetChainId(int assetChainId) {
        this.assetChainId = assetChainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public AccountState getAccountState() {
        return this.accountState;
    }

    public void setAccountState(AccountState accountState) {
        this.accountState = accountState;
    }

    public List<AmountNonce> getNonces() {
        return this.nonces;
    }

    public void setNonces(List<AmountNonce> nonces) {
        this.nonces = nonces;
    }
}

