/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po.sub;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.ledger.constant.LedgerConstant;
import java.io.IOException;
import java.math.BigInteger;

public class AmountNonce
extends BaseNulsData {
    private byte[] fromNonce = LedgerConstant.getInitNonceByte();
    private byte[] nonce = LedgerConstant.getInitNonceByte();
    private BigInteger amount = BigInteger.ZERO;

    public AmountNonce() {
    }

    public AmountNonce(byte[] pFromNonce, byte[] pNonce, BigInteger amount) {
        System.arraycopy(pFromNonce, 0, this.fromNonce, 0, 8);
        System.arraycopy(pNonce, 0, this.nonce, 0, 8);
        this.amount = amount;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.fromNonce);
        stream.write(this.nonce);
        stream.writeBigInteger(this.amount);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.fromNonce = byteBuffer.readBytes(8);
        this.nonce = byteBuffer.readBytes(8);
        this.amount = byteBuffer.readBigInteger();
    }

    public int size() {
        int size = 0;
        size += this.fromNonce.length;
        size += this.nonce.length;
        return size += SerializeUtils.sizeOfBigInteger();
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public byte[] getFromNonce() {
        return this.fromNonce;
    }

    public void setFromNonce(byte[] fromNonce) {
        this.fromNonce = fromNonce;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }
}

