/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.tx.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class TxLedgerAsset
extends BaseNulsData {
    private String name;
    private BigInteger initNumber;
    private short decimalPlace;
    private String symbol;
    private byte[] address;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.name);
        stream.writeBigInteger(this.initNumber);
        stream.writeUint8(this.decimalPlace);
        stream.writeString(this.symbol);
        stream.writeBytesWithLength(this.address);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.name = byteBuffer.readString();
        this.initNumber = byteBuffer.readBigInteger();
        this.decimalPlace = byteBuffer.readUint8();
        this.symbol = byteBuffer.readString();
        this.address = byteBuffer.readByLengthByte();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString((String)this.name);
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfUint8();
        size += SerializeUtils.sizeOfString((String)this.symbol);
        return size += SerializeUtils.sizeOfBytes((byte[])this.address);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigInteger getInitNumber() {
        return this.initNumber;
    }

    public void setInitNumber(BigInteger initNumber) {
        this.initNumber = initNumber;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public short getDecimalPlace() {
        return this.decimalPlace;
    }

    public void setDecimalPlace(short decimalPlace) {
        this.decimalPlace = decimalPlace;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }
}

