/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.call.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.core.rpc.util.RpcCall;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.rpc.call.CallRpcService;
import io.nuls.ledger.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class CallRpcServiceImpl
implements CallRpcService {
    @Autowired
    NulsCoresConfig ledgerConfig;

    @Override
    public long getBlockLatestHeight(int chainId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("chainId", chainId);
        try {
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.BL.abbr, (String)"latestHeight", map);
            if (null != response && response.isSuccess()) {
                Map datas;
                Map responseData = (Map)response.getResponseData();
                if (null != responseData && null != (datas = (Map)responseData.get("latestHeight"))) {
                    return Long.parseLong(datas.get("value").toString());
                }
            } else {
                LoggerUtil.logger(chainId).error("getBlockLatestHeight fail.response={}", new Object[]{JSONUtils.obj2json((Object)response)});
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
        }
        return 0L;
    }

    @Override
    public ErrorCode newTx(Transaction tx) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chainId", this.ledgerConfig.getChainId());
            params.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_newTx", params);
            if (!cmdResp.isSuccess()) {
                return ErrorCode.init((String)cmdResp.getResponseErrorCode());
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return LedgerErrorCode.ERROR_TX_REG_RPC;
        }
        return null;
    }

    @Override
    public ErrorCode transactionSignature(int chainId, String address, String password, Transaction tx) throws NulsException {
        try {
            if (Arrays.equals(AddressTool.getAddressByPubKeyStr((String)this.ledgerConfig.getBlackHolePublicKey(), (int)chainId), AddressTool.getAddress((String)address))) {
                return LedgerErrorCode.ERROR_ADDRESS_ERROR;
            }
            P2PHKSignature p2PHKSignature = new P2PHKSignature();
            HashMap<String, Object> callParams = new HashMap<String, Object>(4);
            callParams.put("chainId", chainId);
            callParams.put("address", address);
            callParams.put("password", password);
            callParams.put("data", RPCUtil.encode((byte[])tx.getHash().getBytes()));
            Response signResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.AC.abbr, (String)"ac_signDigest", callParams);
            if (!signResp.isSuccess()) {
                LoggerUtil.COMMON_LOG.error("ac_signDigest rpc error....{}=={}", new Object[]{signResp.getResponseErrorCode(), signResp.getResponseComment()});
                return ErrorCode.init((String)signResp.getResponseErrorCode());
            }
            HashMap signResult = (HashMap)((HashMap)signResp.getResponseData()).get("ac_signDigest");
            p2PHKSignature.parse(RPCUtil.decode((String)((String)signResult.get("signature"))), 0);
            TransactionSignature signature = new TransactionSignature();
            ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
            p2PHKSignatures.add(p2PHKSignature);
            signature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(signature.serialize());
        }
        catch (NulsException e) {
            LoggerUtil.COMMON_LOG.error(e);
            return LedgerErrorCode.ERROR_SIGNDIGEST;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return LedgerErrorCode.ERROR_SIGNDIGEST;
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getRegisteredChainInfoList(int chainId) {
        try {
            Map map = (Map)RpcCall.request((String)ModuleE.CC.abbr, (String)"getRegisteredChainInfoList", new HashMap());
            List resultList = (List)map.get("list");
            ArrayList<Map<String, Object>> assetList = new ArrayList<Map<String, Object>>();
            for (Map resultMap : resultList) {
                List list;
                int id = (Integer)resultMap.get("chainId");
                if (id == chainId || (list = (List)resultMap.get("assetInfoList")) == null) continue;
                for (Map assetMap : list) {
                    assetMap.put("assetChainId", id);
                    assetMap.put("assetSymbol", assetMap.get("symbol"));
                    assetMap.put("decimalPlace", assetMap.get("decimalPlaces"));
                    assetMap.put("assetAddress", "");
                    assetMap.put("initNumber", 0);
                    assetMap.put("assetType", 1);
                    assetMap.remove("symbol");
                    assetMap.remove("usable");
                    assetMap.remove("decimalPlaces");
                }
                assetList.addAll(list);
            }
            return assetList;
        }
        catch (NulsException e) {
            LoggerUtil.COMMON_LOG.error(e);
            return null;
        }
    }
}

