/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.tx.AssetRegTransaction;
import io.nuls.ledger.model.tx.txdata.TxLedgerAsset;
import io.nuls.ledger.rpc.call.CallRpcService;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class AssetsRegTxCmd
extends BaseLedgerCmd {
    @Autowired
    NulsCoresConfig ledgerConfig;
    @Autowired
    CallRpcService rpcService;
    @Autowired
    AccountStateService accountStateService;
    @Autowired
    AssetRegMngService assetRegMngService;

    CoinData getRegCoinData(BigInteger destroyAsset, byte[] address, int chainId, int assetId, int txSize, AccountState accountState) throws NulsRuntimeException {
        long decimal = (long)Math.pow(10.0, Integer.valueOf(this.ledgerConfig.getDecimals()).intValue());
        BigInteger destroyAssetTx = destroyAsset.multiply(BigInteger.valueOf(decimal));
        txSize += 110;
        CoinData coinData = new CoinData();
        CoinTo to = new CoinTo(AddressTool.getAddressByPubKeyStr((String)this.ledgerConfig.getBlackHolePublicKey(), (int)chainId), chainId, assetId, destroyAssetTx, 0L);
        coinData.addTo(to);
        CoinFrom from = new CoinFrom(address, chainId, assetId, destroyAssetTx, accountState.getNonce(), 0);
        coinData.addFrom(from);
        txSize += to.size();
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)(txSize += from.size()), (long)100000L);
        BigInteger fromAmount = destroyAssetTx.add(fee);
        if (BigIntegerUtils.isLessThan((BigInteger)accountState.getAvailableAmount(), (BigInteger)fromAmount)) {
            throw new NulsRuntimeException(LedgerErrorCode.BALANCE_NOT_ENOUGH);
        }
        from.setAmount(fromAmount);
        return coinData;
    }

    @CmdAnnotation(cmd="chainAssetTxReg", version=1.0, description="In chain asset protocol registration interface")
    @Parameters(value={@Parameter(parameterName="assetName", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset Name: large\u3001Lowercase letters\u3001number\u3001Underline\uff08The underline cannot be at both ends\uff091~20byte"), @Parameter(parameterName="initNumber", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="Initial value of assets"), @Parameter(parameterName="decimalPlace", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-18]", parameterDes="The minimum number of split digits for assets"), @Parameter(parameterName="assetSymbol", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset unit symbol: large\u3001Lowercase letters\u3001number\u3001Underline\uff08The underline cannot be at both ends\uff091~20byte"), @Parameter(parameterName="assetOwnerAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="Address of new asset owner"), @Parameter(parameterName="txCreatorAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="Transaction creator address"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=String.class, description="transactionhashvalue"), @Key(name="chainId", valueType=int.class, description="chainid")}))
    public Response chainAssetTxReg(Map params) {
        HashMap<String, Object> rtMap = new HashMap<String, Object>(3);
        try {
            boolean isAddressValidate;
            TxLedgerAsset asset = LedgerUtil.map2TxLedgerAsset(params);
            ErrorCode errorCode = this.assetRegMngService.commonRegValidator(asset);
            if (null != errorCode) {
                return this.failed(errorCode);
            }
            boolean bl = isAddressValidate = AddressTool.getChainIdByAddress((byte[])asset.getAddress()) == this.ledgerConfig.getChainId();
            if (!isAddressValidate) {
                return this.failed(LedgerErrorCode.ERROR_ADDRESS_ERROR);
            }
            String ledgerAddr = LedgerUtil.getRealAddressStr(params.get("txCreatorAddress").toString());
            AssetRegTransaction tx = new AssetRegTransaction();
            tx.setTxData(asset.serialize());
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            AccountState accountState = this.accountStateService.getAccountStateReCal(ledgerAddr, this.ledgerConfig.getChainId(), this.ledgerConfig.getChainId(), this.ledgerConfig.getAssetId());
            CoinData coinData = this.getRegCoinData(BigInteger.valueOf(this.ledgerConfig.getAssetRegDestroyAmount()), AddressTool.getAddress((String)params.get("txCreatorAddress").toString()), this.ledgerConfig.getChainId(), this.ledgerConfig.getAssetId(), tx.size(), accountState);
            tx.setCoinData(coinData.serialize());
            ErrorCode acErrorCode = this.rpcService.transactionSignature(this.ledgerConfig.getChainId(), (String)params.get("txCreatorAddress"), (String)params.get("password"), tx);
            if (null != acErrorCode) {
                return this.failed(acErrorCode);
            }
            rtMap.put("txHash", tx.getHash().toHex());
            rtMap.put("chainId", this.ledgerConfig.getChainId());
            ErrorCode txErrorCode = this.rpcService.newTx(tx);
            if (null != txErrorCode) {
                return this.failed(txErrorCode);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getAssetRegInfoByHash", version=1.0, description="adoptHashView registered asset information within the chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]"), @Parameter(parameterName="txHash", requestType=@TypeDescriptor(value=String.class), parameterDes="transactionHash")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="assetId", valueType=int.class, description="assetid"), @Key(name="assetType", valueType=int.class, description="Asset type"), @Key(name="assetOwnerAddress", valueType=String.class, description="Address of asset owner"), @Key(name="initNumber", valueType=BigInteger.class, description="Asset initialization value"), @Key(name="decimalPlace", valueType=int.class, description="Decimal Division"), @Key(name="assetName", valueType=String.class, description="Asset Name"), @Key(name="assetSymbol", valueType=String.class, description="Asset symbols"), @Key(name="txHash", valueType=String.class, description="transactionhashvalue")}))
    public Response getAssetRegInfoByHash(Map params) {
        Map<Object, Object> rtMap = new HashMap(1);
        try {
            rtMap = this.assetRegMngService.getLedgerRegAsset((int)Integer.valueOf(params.get("chainId").toString()), params.get("txHash").toString());
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }
}

