/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.manager.LedgerChainManager;
import io.nuls.ledger.model.po.LedgerAsset;
import io.nuls.ledger.rpc.call.CallRpcService;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.ChainAssetsService;
import io.nuls.ledger.storage.AssetRegMngRepository;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class ChainAssetCmd
extends BaseLedgerCmd {
    @Autowired
    ChainAssetsService chainAssetsService;
    @Autowired
    AssetRegMngRepository assetRegMngRepository;
    @Autowired
    LedgerChainManager ledgerChainManager;
    @Autowired
    CallRpcService callRpcService;

    @CmdAnnotation(cmd="getAssetsById", version=1.0, description="Query the amount information of a specified set of assets off the chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="assetIds", requestType=@TypeDescriptor(value=String.class), parameterDes="assetid,Comma separated")})
    @ResponseData(name="Return value", description="Return aListobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="assetId", valueType=Integer.class, description="assetid"), @Key(name="availableAmount", valueType=BigInteger.class, description="Available amount"), @Key(name="freeze", valueType=BigInteger.class, description="Freeze amount")}))
    public Response getAssetsById(Map params) {
        String[] assetIdList;
        Integer addressChainId;
        ArrayList<Map<String, Object>> rtAssetList = new ArrayList<Map<String, Object>>();
        Integer assetChainId = addressChainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(addressChainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        String assetIds = params.get("assetIds").toString();
        for (String assetIdStr : assetIdList = assetIds.split(",")) {
            Map<String, Object> map = this.chainAssetsService.getAssetByChainAssetId(addressChainId, assetChainId, Integer.valueOf(assetIdStr));
            rtAssetList.add(map);
        }
        HashMap<String, ArrayList<Map<String, Object>>> rtMap = new HashMap<String, ArrayList<Map<String, Object>>>();
        rtMap.put("assets", rtAssetList);
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getAssetById", version=1.0, description="Query the amount information of a specified set of assets off the chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="Asset Chainid"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetid")})
    @ResponseData(name="Return value", description="Return aListobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="assetId", valueType=Integer.class, description="assetid"), @Key(name="availableAmount", valueType=BigInteger.class, description="Available amount"), @Key(name="freeze", valueType=BigInteger.class, description="Freeze amount")}))
    public Response getAssetById(Map params) {
        int chainId = (Integer)params.get("chainId");
        int assetChainId = (Integer)params.get("assetChainId");
        int assetId = (Integer)params.get("assetId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        Map<String, Object> map = this.chainAssetsService.getAssetByChainAssetId(chainId, assetChainId, assetId);
        return this.success(map);
    }

    @CmdAnnotation(cmd="lg_get_all_asset", version=1.0, description="View all registered asset information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]")})
    @ResponseData(name="Return value", description="Return alistobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="assetChainId", valueType=int.class, description="Asset Chainid"), @Key(name="assetId", valueType=int.class, description="assetid"), @Key(name="assetType", valueType=int.class, description="Asset type [1-On chain ordinary assets 2-On chain contract assets 3-Parallel chain assets 4-Heterogeneous chain assets 5-On chain ordinary assets bound to heterogeneous chain assets 6-Parallel chain assets bound to heterogeneous chain assets 7-Binding ordinary assets within the chain to multiple heterogeneous chain assets 8-Binding Parallel Chain Assets to Multiple Heterogeneous Chain Assets 9-Binding heterogeneous chain assets to multiple heterogeneous chain assets]"), @Key(name="assetAddress", valueType=String.class, description="Asset address"), @Key(name="initNumber", valueType=BigInteger.class, description="Asset initialization value"), @Key(name="decimalPlace", valueType=int.class, description="Decimal Division"), @Key(name="assetName", valueType=String.class, description="Asset Name"), @Key(name="assetSymbol", valueType=String.class, description="Asset symbols")}))
    public Response getAllCrossChainAssets(Map params) {
        HashMap rtMap = new HashMap(2);
        try {
            int chainId = Integer.parseInt(params.get("chainId").toString());
            List<LedgerAsset> localAssetList = this.assetRegMngRepository.getAllRegLedgerAssets(chainId);
            List assets = localAssetList.stream().map(asset -> asset.toMap()).collect(Collectors.toList());
            assets.add(this.ledgerChainManager.getLocalChainDefaultAsset());
            List<Map<String, Object>> crossAssetList = this.callRpcService.getRegisteredChainInfoList(chainId);
            if (crossAssetList != null) {
                assets.addAll(crossAssetList);
            }
            rtMap.put("assets", assets);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }
}

