/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.manager.LedgerChainManager;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.AccountStateUnconfirmed;
import io.nuls.ledger.model.po.TxUnconfirmed;
import io.nuls.ledger.model.po.sub.AccountStateSnapshot;
import io.nuls.ledger.model.po.sub.AmountNonce;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.FreezeStateService;
import io.nuls.ledger.service.UnconfirmedStateService;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.storage.UnconfirmedRepository;
import io.nuls.ledger.utils.LedgerUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;

@Component
public class AccountStateServiceImpl
implements AccountStateService {
    @Autowired
    private Repository repository;
    @Autowired
    private UnconfirmedRepository unconfirmedRepository;
    @Autowired
    private FreezeStateService freezeStateService;
    @Autowired
    private UnconfirmedStateService unconfirmedStateService;
    @Autowired
    LedgerChainManager ledgerChainManager;

    @Override
    public void rollAccountState(int chainId, List<AccountStateSnapshot> preAccountStates) throws Exception {
        HashMap<byte[], byte[]> accountStates = new HashMap<byte[], byte[]>(preAccountStates.size());
        HashMap<String, AccountState> accountStatesMem = new HashMap<String, AccountState>(preAccountStates.size());
        for (AccountStateSnapshot accountStateSnapshot : preAccountStates) {
            String assetKey = LedgerUtil.getKeyStr(accountStateSnapshot.getAddress(), accountStateSnapshot.getAssetChainId(), accountStateSnapshot.getAssetId());
            accountStates.put(assetKey.getBytes(LedgerConstant.DEFAULT_ENCODING), accountStateSnapshot.getAccountState().serialize());
            accountStatesMem.put(assetKey, accountStateSnapshot.getAccountState());
            HashMap<String, TxUnconfirmed> unconfirmedNonces = new HashMap<String, TxUnconfirmed>(64);
            AccountStateUnconfirmed accountStateUnconfirmed = new AccountStateUnconfirmed();
            List<AmountNonce> list = accountStateSnapshot.getNonces();
            BigInteger amount = BigInteger.ZERO;
            for (AmountNonce amountNonce : list) {
                TxUnconfirmed txUnconfirmed = new TxUnconfirmed(accountStateSnapshot.getAddress(), accountStateSnapshot.getAssetChainId(), accountStateSnapshot.getAssetId(), amountNonce.getFromNonce(), amountNonce.getNonce(), amountNonce.getAmount());
                unconfirmedNonces.put(LedgerUtil.getNonceEncode(amountNonce.getNonce()), txUnconfirmed);
                amount.add(amountNonce.getAmount());
            }
            if (unconfirmedNonces.size() <= 0) continue;
            accountStateUnconfirmed.setNonce(list.get(list.size() - 1).getNonce());
            accountStateUnconfirmed.setFromNonce(list.get(list.size() - 1).getFromNonce());
            accountStateUnconfirmed.setUnconfirmedAmount(amount);
            accountStateUnconfirmed.setCreateTime(NulsDateUtils.getCurrentTimeSeconds());
            this.unconfirmedStateService.mergeUnconfirmedNonce(chainId, accountStateSnapshot.getAccountState(), assetKey, unconfirmedNonces, accountStateUnconfirmed);
        }
        if (accountStates.size() > 0) {
            this.repository.batchUpdateAccountState(chainId, accountStates, accountStatesMem);
        }
    }

    @Override
    public AccountState getAccountState(String address, int addressChainId, int assetChainId, int assetId) {
        AccountState accountState = this.repository.getAccountStateByMemory(addressChainId, LedgerUtil.getKeyStr(address, assetChainId, assetId));
        if (null != accountState) {
            return accountState;
        }
        byte[] key = LedgerUtil.getKey(address, assetChainId, assetId);
        accountState = this.repository.getAccountState(addressChainId, key);
        if (null == accountState) {
            accountState = new AccountState(LedgerConstant.getInitNonceByte());
        }
        return accountState;
    }

    @Override
    public AccountState getAccountStateReCal(String address, int addressChainId, int assetChainId, int assetId) {
        byte[] key;
        AccountState accountState = this.repository.getAccountStateByMemory(addressChainId, LedgerUtil.getKeyStr(address, assetChainId, assetId));
        if (null == accountState && null == (accountState = this.repository.getAccountState(addressChainId, key = LedgerUtil.getKey(address, assetChainId, assetId)))) {
            accountState = new AccountState(LedgerConstant.getInitNonceByte());
            return accountState;
        }
        if (accountState.timeAllow()) {
            this.freezeStateService.recalculateFreeze(addressChainId, accountState);
            accountState.setLatestUnFreezeTime(NulsDateUtils.getCurrentTimeSeconds());
        }
        return accountState;
    }
}

