/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.base.data.Block;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.model.ChainHeight;
import io.nuls.ledger.model.po.BlockSnapshotAccounts;
import io.nuls.ledger.model.po.BlockSnapshotTxs;
import io.nuls.ledger.model.po.sub.AccountStateSnapshot;
import io.nuls.ledger.rpc.call.CallRpcService;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.BlockDataService;
import io.nuls.ledger.service.ChainAssetsService;
import io.nuls.ledger.service.TransactionService;
import io.nuls.ledger.storage.LgBlockSyncRepository;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.CoinDataUtil;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.util.HashMap;
import java.util.List;

@Component
public class BlockDataServiceImpl
implements BlockDataService {
    @Autowired
    private Repository repository;
    @Autowired
    LgBlockSyncRepository lgBlockSyncRepository;
    @Autowired
    private AccountStateService accountStateService;
    @Autowired
    private ChainAssetsService chainAssetsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CallRpcService callRpcService;

    @Override
    public void initBlockDatas() throws Exception {
        List<ChainHeight> list = this.getChainsBlockHeight();
        if (null != list) {
            LoggerUtil.COMMON_LOG.info("chainList size = {}", new Object[]{list.size()});
            for (ChainHeight chainHeight : list) {
                Log.info((String)"begin chain ledger checked..chainId = {},chainHeight={}", (Object[])new Object[]{chainHeight.getChainId(), chainHeight.getBlockHeight()});
                BlockSnapshotAccounts blockSnapshotAccounts = this.repository.getBlockSnapshot(chainHeight.getChainId(), chainHeight.getBlockHeight() + 1L);
                if (null != blockSnapshotAccounts) {
                    List<AccountStateSnapshot> preAccountStates = blockSnapshotAccounts.getAccounts();
                    this.accountStateService.rollAccountState(chainHeight.getChainId(), preAccountStates);
                }
                LoggerUtil.COMMON_LOG.info("end chain ledger checked..chainId = {},chainHeight={}", new Object[]{chainHeight.getChainId(), chainHeight.getBlockHeight()});
            }
        }
    }

    @Override
    public void syncBlockHeight() throws Exception {
        List<ChainHeight> list = this.getChainsBlockHeight();
        if (null != list) {
            LoggerUtil.COMMON_LOG.info("syncBlockHeight size = {}", new Object[]{list.size()});
            for (ChainHeight chainHeight : list) {
                Log.info((String)"####begin syncBlockHeight..chainId = {},chainHeight={}", (Object[])new Object[]{chainHeight.getChainId(), chainHeight.getBlockHeight()});
                long blockHeight = this.callRpcService.getBlockLatestHeight(chainHeight.getChainId());
                if (blockHeight <= 0L || blockHeight + 1L != chainHeight.getBlockHeight()) continue;
                LoggerUtil.logger(chainHeight.getChainId()).debug("rollBackBlockTxs chainId={},blockHeight={}", new Object[]{chainHeight.getChainId(), chainHeight.getBlockHeight()});
                this.repository.saveOrUpdateBlockHeight(chainHeight.getChainId(), blockHeight);
                BlockSnapshotAccounts blockSnapshotAccounts = this.repository.getBlockSnapshot(chainHeight.getChainId(), chainHeight.getBlockHeight());
                if (null != blockSnapshotAccounts) {
                    List<AccountStateSnapshot> preAccountStates = blockSnapshotAccounts.getAccounts();
                    this.accountStateService.rollAccountState(chainHeight.getChainId(), preAccountStates);
                    this.repository.delBlockSnapshot(chainHeight.getChainId(), blockHeight);
                    Log.info((String)"####end syncBlockHeight..chainId = {},chainHeight={}", (Object[])new Object[]{chainHeight.getChainId(), chainHeight.getBlockHeight()});
                }
                this.rollBackBlockDatas(chainHeight.getChainId(), blockHeight + 1L);
            }
        }
    }

    @Override
    public List<ChainHeight> getChainsBlockHeight() throws Exception {
        return this.repository.getChainsBlockHeight();
    }

    @Override
    public void syncBlockDatas(int addressChainId, long height, Block block) throws Exception {
        HashMap<byte[], byte[]> saveHashMap = new HashMap<byte[], byte[]>(5120);
        HashMap<byte[], byte[]> ledgerNonce = new HashMap<byte[], byte[]>(5120);
        HashMap<String, List<String>> assetAddressIndex = new HashMap<String, List<String>>();
        BlockSnapshotTxs blockSnapshotTxs = new BlockSnapshotTxs();
        blockSnapshotTxs.setBlockHash(block.getHeader().getHash().toHex());
        List txList = block.getTxs();
        for (Transaction transaction : txList) {
            byte[] nonce8Bytes = LedgerUtil.getNonceByTx(transaction);
            String txHash = transaction.getHash().toHex();
            blockSnapshotTxs.addHash(txHash);
            saveHashMap.put(ByteUtils.toBytes((CharSequence)txHash, (String)LedgerConstant.DEFAULT_ENCODING), ByteUtils.longToBytes((long)height));
            CoinData coinData = CoinDataUtil.parseCoinData(transaction.getCoinData());
            if (null == coinData) continue;
            List froms = coinData.getFrom();
            for (CoinFrom from : froms) {
                String address = LedgerUtil.getRealAddressStr(from.getAddress());
                if (LedgerUtil.isNotLocalChainAccount(addressChainId, from.getAddress())) continue;
                LedgerUtil.dealAssetAddressIndex(assetAddressIndex, from.getAssetsChainId(), from.getAssetsId(), address);
                if (from.getLocked() != 0) continue;
                String nonce8Str = LedgerUtil.getNonceEncode(nonce8Bytes);
                String addressNonce = LedgerUtil.getAccountNoncesStrKey(address, from.getAssetsChainId(), from.getAssetsId(), nonce8Str);
                blockSnapshotTxs.addNonce(addressNonce);
                ledgerNonce.put(ByteUtils.toBytes((CharSequence)addressNonce, (String)LedgerConstant.DEFAULT_ENCODING), ByteUtils.intToBytes((int)1));
            }
            List tos = coinData.getTo();
            for (CoinTo to : tos) {
                if (LedgerUtil.isNotLocalChainAccount(addressChainId, to.getAddress())) continue;
                String address = LedgerUtil.getRealAddressStr(to.getAddress());
                LedgerUtil.dealAssetAddressIndex(assetAddressIndex, to.getAssetsChainId(), to.getAssetsId(), address);
            }
        }
        this.lgBlockSyncRepository.bakBlockInfosByHeight(addressChainId, height, blockSnapshotTxs);
        this.lgBlockSyncRepository.saveBlockHashByHeight(addressChainId, height, block.getHeader().getHash().toHex());
        this.chainAssetsService.updateChainAssets(addressChainId, assetAddressIndex);
        this.lgBlockSyncRepository.saveAccountNonces(addressChainId, ledgerNonce);
        this.lgBlockSyncRepository.saveAccountHash(addressChainId, saveHashMap);
        this.lgBlockSyncRepository.saveOrUpdateSyncBlockHeight(addressChainId, height);
    }

    @Override
    public void clearSurplusBakDatas(int addressChainId, long height) {
        if (height > 100L) {
            this.lgBlockSyncRepository.delBlockSnapshotTxs(addressChainId, height - 100L);
        }
        if (height > 1000L) {
            try {
                this.repository.delBlockSnapshot(addressChainId, height - 1000L);
            }
            catch (Exception e) {
                LoggerUtil.logger(addressChainId).error(e);
            }
        }
    }

    @Override
    public void rollBackBlockDatas(int chainId, long height) throws Exception {
        BlockSnapshotTxs blockSnapshotTxs = this.lgBlockSyncRepository.getBlockSnapshotTxs(chainId, height);
        if (null != blockSnapshotTxs) {
            this.lgBlockSyncRepository.delBlockHash(chainId, height);
            this.lgBlockSyncRepository.batchDeleteAccountHash(chainId, blockSnapshotTxs.getTxHashList());
            this.lgBlockSyncRepository.batchDeleteAccountNonces(chainId, blockSnapshotTxs.getAddressNonceList());
            LoggerUtil.logger(chainId).debug("rollBackBlockDatas chainId={},blockHeight={}", new Object[]{chainId, height});
        }
        this.lgBlockSyncRepository.saveOrUpdateSyncBlockHeight(chainId, height - 1L);
        this.lgBlockSyncRepository.delBlockSnapshotTxs(chainId, height);
    }

    @Override
    public String getBlockHashByHeight(int chainId, long height) throws Exception {
        return this.lgBlockSyncRepository.getBlockHash(chainId, height);
    }

    @Override
    public long currentSyncHeight(int chainId) throws Exception {
        return this.lgBlockSyncRepository.getSyncBlockHeight(chainId);
    }
}

