/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.processor;

import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.sub.FreezeHeightState;
import io.nuls.ledger.model.po.sub.FreezeLockTimeState;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.processor.TxLockedProcessor;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.util.List;

@Component
public class LockedTransactionProcessor
implements TxLockedProcessor {
    @Autowired
    AccountStateService accountStateService;
    @Autowired
    Repository repository;

    private boolean processFromCoinData(CoinFrom coin, String txHash, AccountState accountState, String address) {
        if (coin.getLocked() == -1) {
            List<FreezeLockTimeState> list = accountState.getFreezeLockTimeStates();
            for (FreezeLockTimeState freezeLockTimeState : list) {
                LoggerUtil.COMMON_LOG.debug("processFromCoinData remove TimeUnlocked address={},amount={}={},nonce={}={},hash={} ", new Object[]{address, coin.getAmount(), freezeLockTimeState.getAmount(), LedgerUtil.getNonceEncode(coin.getNonce()), LedgerUtil.getNonceEncode(freezeLockTimeState.getNonce()), txHash});
                if (!LedgerUtil.equalsNonces(freezeLockTimeState.getNonce(), coin.getNonce()) || 0 != freezeLockTimeState.getAmount().compareTo(coin.getAmount())) continue;
                list.remove((Object)freezeLockTimeState);
                LoggerUtil.COMMON_LOG.debug("TimeUnlocked remove ok,hash={} ", new Object[]{txHash});
                return true;
            }
        } else {
            List<FreezeHeightState> list = accountState.getFreezeHeightStates();
            for (FreezeHeightState freezeHeightState : list) {
                Log.debug((String)"processFromCoinData remove HeightUnlocked address={},amount={}={},nonce={}={},hash={} ", (Object[])new Object[]{address, coin.getAmount(), freezeHeightState.getAmount(), LedgerUtil.getNonceEncode(coin.getNonce()), LedgerUtil.getNonceEncode(freezeHeightState.getNonce()), txHash});
                if (!LedgerUtil.equalsNonces(freezeHeightState.getNonce(), coin.getNonce()) || 0 != freezeHeightState.getAmount().compareTo(coin.getAmount())) continue;
                list.remove((Object)freezeHeightState);
                LoggerUtil.COMMON_LOG.debug("HeightUnlocked remove ok,hash={} ", new Object[]{txHash});
                return true;
            }
        }
        return false;
    }

    private boolean processToCoinData(CoinTo coin, byte[] nonce, String hash, AccountState accountState, long txTime, String address) {
        if (coin.getLockTime() < 1000000000L && !LedgerUtil.isPermanentLock(coin.getLockTime())) {
            FreezeHeightState freezeHeightState = new FreezeHeightState();
            freezeHeightState.setAmount(coin.getAmount());
            freezeHeightState.setCreateTime(txTime);
            freezeHeightState.setHeight(coin.getLockTime());
            freezeHeightState.setNonce(nonce);
            freezeHeightState.setTxHash(hash);
            LoggerUtil.COMMON_LOG.debug("processToCoinData add HeightLocked address={},amount={},height={},hash={} ", new Object[]{address, freezeHeightState.getAmount(), freezeHeightState.getHeight(), hash});
            accountState.getFreezeHeightStates().add(freezeHeightState);
        } else {
            FreezeLockTimeState freezeLockTimeState = new FreezeLockTimeState();
            freezeLockTimeState.setAmount(coin.getAmount());
            freezeLockTimeState.setCreateTime(txTime);
            freezeLockTimeState.setLockTime(coin.getLockTime());
            freezeLockTimeState.setNonce(nonce);
            freezeLockTimeState.setTxHash(hash);
            LoggerUtil.COMMON_LOG.debug("processToCoinData add TimeLocked address={},amount={},time={},hash={} ", new Object[]{address, coin.getAmount(), freezeLockTimeState.getLockTime(), hash});
            accountState.getFreezeLockTimeStates().add(freezeLockTimeState);
        }
        return true;
    }

    @Override
    public boolean processCoinData(Coin coin, byte[] nonce, String txHash, List<FreezeLockTimeState> timeStateList, List<FreezeHeightState> heightStateList, String address, boolean isFromCoin) {
        if (isFromCoin) {
            CoinFrom coinFrom = (CoinFrom)coin;
            if (coinFrom.getLocked() == -1) {
                for (FreezeLockTimeState freezeLockTimeState : timeStateList) {
                    LoggerUtil.COMMON_LOG.debug("processFromCoinData remove TimeUnlocked address={},amount={}={},nonce={}={},hash={} ", new Object[]{address, coin.getAmount(), freezeLockTimeState.getAmount(), LedgerUtil.getNonceEncode(coinFrom.getNonce()), LedgerUtil.getNonceEncode(freezeLockTimeState.getNonce()), txHash});
                    if (!LedgerUtil.equalsNonces(freezeLockTimeState.getNonce(), coinFrom.getNonce()) || 0 != freezeLockTimeState.getAmount().compareTo(coin.getAmount())) continue;
                    timeStateList.remove((Object)freezeLockTimeState);
                    LoggerUtil.COMMON_LOG.debug("TimeUnlocked remove ok,hash={} ", new Object[]{txHash});
                    return true;
                }
            } else {
                for (FreezeHeightState freezeHeightState : heightStateList) {
                    Log.debug((String)"processFromCoinData remove HeightUnlocked address={},amount={}={},nonce={}={},hash={} ", (Object[])new Object[]{address, coin.getAmount(), freezeHeightState.getAmount(), LedgerUtil.getNonceEncode(coinFrom.getNonce()), LedgerUtil.getNonceEncode(freezeHeightState.getNonce()), txHash});
                    if (!LedgerUtil.equalsNonces(freezeHeightState.getNonce(), coinFrom.getNonce()) || 0 != freezeHeightState.getAmount().compareTo(coin.getAmount())) continue;
                    heightStateList.remove((Object)freezeHeightState);
                    LoggerUtil.COMMON_LOG.debug("HeightUnlocked remove ok,hash={} ", new Object[]{txHash});
                    return true;
                }
            }
        } else {
            CoinTo coinTo = (CoinTo)coin;
            if (coinTo.getLockTime() < 1000000000L && !LedgerUtil.isPermanentLock(coinTo.getLockTime())) {
                FreezeHeightState freezeHeightState = new FreezeHeightState();
                freezeHeightState.setAmount(coin.getAmount());
                freezeHeightState.setHeight(coinTo.getLockTime());
                freezeHeightState.setNonce(nonce);
                freezeHeightState.setTxHash(txHash);
                LoggerUtil.COMMON_LOG.debug("processToCoinData add HeightLocked address={},amount={},height={},hash={} ", new Object[]{address, freezeHeightState.getAmount(), freezeHeightState.getHeight(), txHash});
                heightStateList.add(freezeHeightState);
            } else {
                FreezeLockTimeState freezeLockTimeState = new FreezeLockTimeState();
                freezeLockTimeState.setAmount(coin.getAmount());
                freezeLockTimeState.setLockTime(coinTo.getLockTime());
                freezeLockTimeState.setNonce(nonce);
                freezeLockTimeState.setTxHash(txHash);
                LoggerUtil.COMMON_LOG.debug("processToCoinData add TimeLocked address={},amount={},time={},hash={} ", new Object[]{address, coin.getAmount(), freezeLockTimeState.getLockTime(), txHash});
                timeStateList.add(freezeLockTimeState);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean processCoinData(Coin coin, byte[] nonce, String txHash, AccountState accountState, long txTime, String address, boolean isFromCoin) {
        if (isFromCoin) {
            return this.processFromCoinData((CoinFrom)coin, txHash, accountState, address);
        }
        return this.processToCoinData((CoinTo)coin, nonce, txHash, accountState, txTime, address);
    }
}

