/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.utils;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.ledger.model.po.TxUnconfirmed;
import java.util.Map;

public class CoinDataUtil {
    public static CoinData parseCoinData(byte[] stream) {
        if (null == stream) {
            return null;
        }
        CoinData coinData = new CoinData();
        try {
            coinData.parse(new NulsByteBuffer(stream));
        }
        catch (NulsException e) {
            Log.error((String)"coinData parse error", (Throwable)e);
        }
        return coinData;
    }

    public static void calTxFromAmount(Map<String, TxUnconfirmed> map, CoinFrom coinFrom, byte[] txNonce, String accountKey, String address) {
        if (null == map.get(accountKey)) {
            TxUnconfirmed txUnconfirmed = new TxUnconfirmed(address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), coinFrom.getNonce(), txNonce, coinFrom.getAmount());
            map.put(accountKey, txUnconfirmed);
        } else {
            TxUnconfirmed txUnconfirmed = map.get(accountKey);
            System.arraycopy(txNonce, 0, txUnconfirmed.getNonce(), 0, 8);
            System.arraycopy(coinFrom.getNonce(), 0, txUnconfirmed.getFromNonce(), 0, 8);
            txUnconfirmed.setAmount(txUnconfirmed.getAmount().add(coinFrom.getAmount()));
        }
    }
}

