/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.utils;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.log.Log;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.model.tx.txdata.TxLedgerAsset;
import io.nuls.ledger.utils.LoggerUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LedgerUtil {
    public static String getRealAddressStr(String addrContainPre) {
        return AddressTool.getRealAddress((String)addrContainPre);
    }

    public static String getRealAddressStr(byte[] coinAddr) {
        return AddressTool.getStringAddressNoPrefix((byte[])coinAddr);
    }

    public static String getKeyStr(String address, int assetChainId, int assetId) {
        return address + "-" + assetChainId + "-" + assetId;
    }

    public static byte[] getKey(String address, int assetChainId, int assetId) {
        String key = address + "-" + assetChainId + "-" + assetId;
        try {
            return key.getBytes(LedgerConstant.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    public static byte[] getNonceDecode(String nonceStr) {
        return HexUtil.decode((String)nonceStr);
    }

    public static String getNonceEncode(byte[] nonce) {
        return HexUtil.encode((byte[])nonce);
    }

    public static String getNonceEncodeByTx(Transaction tx) {
        byte[] out = new byte[8];
        byte[] in = tx.getHash().getBytes();
        int copyEnd = in.length;
        System.arraycopy(in, copyEnd - 8, out, 0, 8);
        return HexUtil.encode((byte[])out);
    }

    public static byte[] getNonceByTx(Transaction tx) {
        byte[] out = new byte[8];
        byte[] in = tx.getHash().getBytes();
        int copyEnd = in.length;
        System.arraycopy(in, copyEnd - 8, out, 0, 8);
        return out;
    }

    public static String getNonceEncodeByTxHash(String txHash) {
        return txHash.substring(txHash.length() - 16);
    }

    public static byte[] getNonceDecodeByTxHash(String txHash) {
        byte[] out = new byte[8];
        byte[] in = HexUtil.decode((String)txHash);
        int copyEnd = in.length;
        System.arraycopy(in, copyEnd - 8, out, 0, 8);
        return out;
    }

    public static boolean equalsNonces(byte[] nonce1, byte[] nonce2) {
        return Arrays.equals(nonce1, nonce2);
    }

    public static boolean isNotLocalChainAccount(int chainId, byte[] address) {
        try {
            int assetChainId = AddressTool.getChainIdByAddress((byte[])address);
            return chainId != assetChainId;
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
            return false;
        }
    }

    public static boolean isCrossTx(int txType) {
        return txType == 10 || txType == 26;
    }

    public static String getAccountAssetStrKey(CoinFrom from) {
        return LedgerUtil.getRealAddressStr(from.getAddress()) + "-" + from.getAssetsChainId() + "-" + from.getAssetsId();
    }

    public static String getAccountNoncesStrKey(String address, int assetChainId, int assetId, String nonce) {
        return address + "-" + assetChainId + "-" + assetId + "-" + nonce;
    }

    public static int getVersion(int chainId) {
        short version = ProtocolGroupManager.getCurrentVersion((int)chainId);
        return version;
    }

    public static boolean isBlackHoleAddress(int chainId, byte[] address) {
        if (address == null) {
            return false;
        }
        int chainIdByAddress = AddressTool.getChainIdByAddress((byte[])address);
        if (chainIdByAddress != 1) {
            return false;
        }
        String contractAddress = AddressTool.getStringAddressByBytes((byte[])address);
        if (LedgerUtil.getVersion(chainId) >= 5) {
            return AddressTool.BLOCK_HOLE_ADDRESS_SET.contains(contractAddress) || AddressTool.BLOCK_HOLE_ADDRESS_SET_5.contains(contractAddress);
        }
        return AddressTool.BLOCK_HOLE_ADDRESS_SET.contains(contractAddress);
    }

    public static TxLedgerAsset map2TxLedgerAsset(Map<String, Object> map) {
        TxLedgerAsset txLedgerAsset = new TxLedgerAsset();
        txLedgerAsset.setName(String.valueOf(map.get("assetName")));
        BigInteger initNumber = new BigInteger(String.valueOf(map.get("initNumber")));
        txLedgerAsset.setInitNumber(initNumber);
        txLedgerAsset.setDecimalPlace(Short.valueOf(map.get("decimalPlace").toString()));
        txLedgerAsset.setSymbol(String.valueOf(map.get("assetSymbol")));
        txLedgerAsset.setAddress(AddressTool.getAddress((String)map.get("assetOwnerAddress").toString()));
        return txLedgerAsset;
    }

    public static void dealAssetAddressIndex(Map<String, List<String>> assetAddressIndex, int chainId, int assetId, String address) {
        String assetIndexKey = chainId + "-" + assetId;
        List<Object> addressList = null;
        if (null == assetAddressIndex.get(assetIndexKey)) {
            addressList = new ArrayList();
            assetAddressIndex.put(assetIndexKey, addressList);
        } else {
            addressList = assetAddressIndex.get(assetIndexKey);
        }
        addressList.add(address);
    }

    public static boolean isPermanentLock(long lockTime) {
        return lockTime < 0L;
    }
}

