/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.validator;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.TempAccountNonce;
import io.nuls.ledger.model.ValidateResult;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.AccountStateUnconfirmed;
import io.nuls.ledger.model.po.TxUnconfirmed;
import io.nuls.ledger.model.po.sub.FreezeHeightState;
import io.nuls.ledger.model.po.sub.FreezeLockTimeState;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.TransactionService;
import io.nuls.ledger.service.UnconfirmedStateService;
import io.nuls.ledger.service.processor.TxLockedProcessor;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.CoinDataUtil;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class CoinDataValidator {
    private Map<String, Map<String, String>> chainsBatchValidateTxMap = new ConcurrentHashMap<String, Map<String, String>>();
    private Map<String, Map<String, List<TempAccountNonce>>> chainsAccountNonceMap = new ConcurrentHashMap<String, Map<String, List<TempAccountNonce>>>();
    private Map<String, Map<String, AccountState>> chainsAccountStateMap = new ConcurrentHashMap<String, Map<String, AccountState>>();
    private Map<String, Map<String, List<FreezeLockTimeState>>> chainsLockedTimeMap = new ConcurrentHashMap<String, Map<String, List<FreezeLockTimeState>>>();
    private Map<String, Map<String, List<FreezeHeightState>>> chainsLockedHeightMap = new ConcurrentHashMap<String, Map<String, List<FreezeHeightState>>>();
    @Autowired
    private AccountStateService accountStateService;
    @Autowired
    private UnconfirmedStateService unconfirmedStateService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private Repository repository;
    @Autowired
    private TxLockedProcessor txLockedProcessor;

    public Map<String, String> getBatchValidateTxMap(int addressChainId) {
        return this.chainsBatchValidateTxMap.get(String.valueOf(addressChainId));
    }

    public Map<String, List<TempAccountNonce>> getAccountBalanceValidateMap(int addressChainId) {
        return this.chainsAccountNonceMap.get(String.valueOf(addressChainId));
    }

    public Map<String, AccountState> getAccountValidateMap(int addressChainId) {
        return this.chainsAccountStateMap.get(String.valueOf(addressChainId));
    }

    public Map<String, List<FreezeLockTimeState>> getFreezeLockTimeValidateMap(int addressChainId) {
        if (null == this.chainsLockedTimeMap.get(String.valueOf(addressChainId))) {
            this.chainsLockedTimeMap.put(String.valueOf(addressChainId), new ConcurrentHashMap());
        }
        return this.chainsLockedTimeMap.get(String.valueOf(addressChainId));
    }

    public List<FreezeLockTimeState> getFreezeLockTimeValidateList(Map<String, List<FreezeLockTimeState>> timeLockedMap, String assetKey) {
        List<FreezeLockTimeState> timeStateList = timeLockedMap.get(assetKey);
        if (null == timeStateList) {
            timeStateList = new ArrayList<FreezeLockTimeState>();
            timeLockedMap.put(assetKey, timeStateList);
        }
        return timeStateList;
    }

    public Map<String, List<FreezeHeightState>> getFreezeLockHeightValidateMap(int addressChainId) {
        if (null == this.chainsLockedHeightMap.get(String.valueOf(addressChainId))) {
            this.chainsLockedHeightMap.put(String.valueOf(addressChainId), new ConcurrentHashMap());
        }
        return this.chainsLockedHeightMap.get(String.valueOf(addressChainId));
    }

    public List<FreezeHeightState> getFreezeLockHeightValidateList(Map<String, List<FreezeHeightState>> heightMap, String assetKey) {
        List<FreezeHeightState> heightStateList = heightMap.get(assetKey);
        if (null == heightStateList) {
            heightStateList = new ArrayList<FreezeHeightState>();
            heightMap.put(assetKey, heightStateList);
        }
        return heightStateList;
    }

    public boolean beginBatchPerTxValidate(int chainId) {
        Map<String, List<FreezeHeightState>> heightMap;
        Map<String, List<FreezeLockTimeState>> timeMap;
        Map<String, AccountState> accountStateMap;
        Map<String, List<TempAccountNonce>> accountBalanceValidateTxMap;
        Map<String, String> batchValidateTxMap = this.getBatchValidateTxMap(chainId);
        if (null == batchValidateTxMap) {
            batchValidateTxMap = new ConcurrentHashMap<String, String>(1024);
            this.chainsBatchValidateTxMap.put(String.valueOf(chainId), batchValidateTxMap);
        }
        if (null == (accountBalanceValidateTxMap = this.getAccountBalanceValidateMap(chainId))) {
            accountBalanceValidateTxMap = new ConcurrentHashMap<String, List<TempAccountNonce>>(1024);
            this.chainsAccountNonceMap.put(String.valueOf(chainId), accountBalanceValidateTxMap);
        }
        if (null == (accountStateMap = this.getAccountValidateMap(chainId))) {
            accountStateMap = new ConcurrentHashMap<String, AccountState>(1024);
            this.chainsAccountStateMap.put(String.valueOf(chainId), accountStateMap);
        }
        if (null == (timeMap = this.getFreezeLockTimeValidateMap(chainId))) {
            timeMap = new ConcurrentHashMap<String, List<FreezeLockTimeState>>(1024);
            this.chainsLockedTimeMap.put(String.valueOf(chainId), timeMap);
        }
        if (null == (heightMap = this.getFreezeLockHeightValidateMap(chainId))) {
            heightMap = new ConcurrentHashMap<String, List<FreezeHeightState>>(1024);
            this.chainsLockedHeightMap.put(String.valueOf(chainId), heightMap);
        }
        batchValidateTxMap.clear();
        accountBalanceValidateTxMap.clear();
        accountStateMap.clear();
        timeMap.clear();
        heightMap.clear();
        return true;
    }

    public boolean blockValidate(int chainId, long height, List<Transaction> txs) {
        LoggerUtil.logger(chainId).debug("blocksValidate chainId={},height={},txsNumber={}", new Object[]{chainId, height, txs.size()});
        long currentDbHeight = this.repository.getBlockHeight(chainId);
        if (height - currentDbHeight > 1L || height - currentDbHeight <= 0L) {
            LoggerUtil.logger(chainId).error("addressChainId ={},blockHeight={},ledgerBlockHeight={}", new Object[]{chainId, height, currentDbHeight});
            return false;
        }
        HashSet<String> batchValidateTxSet = new HashSet<String>(txs.size());
        HashMap<String, List<TempAccountNonce>> accountValidateTxMap = new HashMap<String, List<TempAccountNonce>>(1024);
        HashMap<String, AccountState> accountStateMap = new HashMap<String, AccountState>(1024);
        HashMap<String, Object> lockedCancelNonceMap = new HashMap<String, Object>(32);
        ConcurrentHashMap<String, List<FreezeLockTimeState>> lockedTimeMap = new ConcurrentHashMap<String, List<FreezeLockTimeState>>();
        ConcurrentHashMap<String, List<FreezeHeightState>> lockedHeightMap = new ConcurrentHashMap<String, List<FreezeHeightState>>();
        for (Transaction transaction : txs) {
            ValidateResult validateResult;
            transaction.setBlockHeight(height);
            if (LoggerUtil.logger(chainId).isDebugEnabled()) {
                LoggerUtil.logger(chainId).debug("[TEST] blocksValidate tx type: {}, hash: {}", new Object[]{transaction.getType(), transaction.getHash().toHex()});
            }
            if ((validateResult = this.blockTxsValidate(chainId, transaction, batchValidateTxSet, accountValidateTxMap, accountStateMap, lockedCancelNonceMap, lockedTimeMap, lockedHeightMap)).isSuccess()) continue;
            LoggerUtil.logger(chainId).error("code={},msg={}", new Object[]{validateResult.getValidateCode(), validateResult.getValidateDesc()});
            return false;
        }
        for (Map.Entry entry : accountStateMap.entrySet()) {
            if (!BigIntegerUtils.isLessThan((BigInteger)((AccountState)((Object)entry.getValue())).getAvailableAmount(), (BigInteger)BigInteger.ZERO)) continue;
            LoggerUtil.logger(chainId).info("{}==balance is not enough", new Object[]{entry.getKey()});
            return false;
        }
        return true;
    }

    public ValidateResult bathValidatePerTx(int chainId, Transaction tx) {
        Map<String, String> batchValidateTxMap = this.getBatchValidateTxMap(chainId);
        Map<String, List<TempAccountNonce>> accountBalanceValidateTxMap = this.getAccountBalanceValidateMap(chainId);
        return this.confirmedTxValidate(chainId, tx, batchValidateTxMap, accountBalanceValidateTxMap);
    }

    public ValidateResult verifyCoinData(int addressChainId, Transaction transaction) throws Exception {
        ValidateResult validateResult = this.validateCoinData(addressChainId, transaction);
        if (!validateResult.isSuccess()) {
            LoggerUtil.logger(addressChainId).error("validateResult = {}={}", new Object[]{validateResult.getValidateCode(), validateResult.getValidateDesc()});
            return validateResult;
        }
        return ValidateResult.getSuccess();
    }

    private ValidateResult analysisFromCoinPerTx(int chainId, int txType, long blockHeight, byte[] nonce8Bytes, List<CoinFrom> coinFroms, Map<String, List<TempAccountNonce>> accountValidateTxMap, Map<String, AccountState> accountStateMap, Map<String, BigInteger> balanceValidateMap) {
        long hardForkingHeight = 878000L;
        boolean forked = blockHeight <= 0L || blockHeight > hardForkingHeight;
        for (CoinFrom coinFrom : coinFroms) {
            String address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
            if (LedgerUtil.isNotLocalChainAccount(chainId, coinFrom.getAddress())) {
                if (LedgerUtil.isCrossTx(txType)) continue;
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "address Not local chain Exception"});
            }
            if (AddressTool.isBlackHoleAddress((byte[])LedgerConstant.blackHolePublicKey, (int)chainId, (byte[])coinFrom.getAddress())) {
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "address is blackHoleAddress Exception"});
            }
            if (forked && LedgerUtil.isBlackHoleAddress(chainId, coinFrom.getAddress())) {
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "address is blackHoleAddress Exception[x]"});
            }
            String assetKey = LedgerUtil.getKeyStr(address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            AccountState accountState = accountStateMap.get(assetKey);
            List<FreezeLockTimeState> timeStates = this.getFreezeLockTimeValidateList(this.getFreezeLockTimeValidateMap(chainId), assetKey);
            List<FreezeHeightState> heightStates = this.getFreezeLockHeightValidateList(this.getFreezeLockHeightValidateMap(chainId), assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeStates.addAll(accountState.getFreezeLockTimeStates());
                heightStates.addAll(accountState.getFreezeHeightStates());
            }
            BigInteger availableAmount = accountState.getAvailableAmount();
            balanceValidateMap.computeIfAbsent(assetKey, a -> availableAmount);
            if (coinFrom.getLocked() == 0) {
                ValidateResult validateResult = this.isValidateCommonTxBatch(chainId, accountState, coinFrom, nonce8Bytes, accountValidateTxMap);
                if (!validateResult.isSuccess()) {
                    LoggerUtil.logger(chainId).error("fail tx type:" + txType);
                    return validateResult;
                }
                balanceValidateMap.computeIfPresent(assetKey, (k, v) -> v.subtract(coinFrom.getAmount()));
                continue;
            }
            if (this.isValidateFreezeTxWithTemp(timeStates, heightStates, coinFrom.getLocked(), coinFrom.getAmount(), coinFrom.getNonce())) continue;
            return ValidateResult.getResult(LedgerErrorCode.DOUBLE_EXPENSES, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce())});
        }
        return ValidateResult.getSuccess();
    }

    private ValidateResult analysisToCoinPerTx(int chainId, int txType, List<CoinTo> coinTos, Map<String, AccountState> accountStateMap, Map<String, List<FreezeLockTimeState>> timeStatesMap, Map<String, List<FreezeHeightState>> heightStatesMap, Map<String, BigInteger> balanceValidateMap) {
        for (CoinTo coinTo : coinTos) {
            if (LedgerUtil.isNotLocalChainAccount(chainId, coinTo.getAddress())) {
                if (LedgerUtil.isCrossTx(txType)) continue;
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{LedgerUtil.getRealAddressStr(coinTo.getAddress()), "--", "address Not local chain Exception"});
            }
            String address = LedgerUtil.getRealAddressStr(coinTo.getAddress());
            String assetKey = LedgerUtil.getKeyStr(address, coinTo.getAssetsChainId(), coinTo.getAssetsId());
            AccountState accountState = accountStateMap.get(assetKey);
            List<FreezeLockTimeState> timeList = this.getFreezeLockTimeValidateList(timeStatesMap, assetKey);
            List<FreezeHeightState> heightList = this.getFreezeLockHeightValidateList(heightStatesMap, assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinTo.getAssetsChainId(), coinTo.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeList.addAll(accountState.getFreezeLockTimeStates());
                heightList.addAll(accountState.getFreezeHeightStates());
            }
            BigInteger availableAmount = accountState.getAvailableAmount();
            balanceValidateMap.computeIfAbsent(assetKey, a -> availableAmount);
            if (coinTo.getLockTime() != 0L) continue;
            balanceValidateMap.computeIfPresent(assetKey, (k, v) -> v.add(coinTo.getAmount()));
        }
        return ValidateResult.getSuccess();
    }

    public ValidateResult confirmedTxValidate(int chainId, Transaction tx, Map<String, String> batchValidateTxMap, Map<String, List<TempAccountNonce>> accountValidateTxMap) {
        Map<String, AccountState> accountStateMap = this.getAccountValidateMap(chainId);
        HashMap<String, BigInteger> balanceValidateMap = new HashMap<String, BigInteger>(64);
        String txHash = tx.getHash().toHex();
        int txType = tx.getType();
        if (null != batchValidateTxMap.get(txHash)) {
            LoggerUtil.logger(chainId).error("{} tx exist!", new Object[]{txHash});
            return ValidateResult.getResult(LedgerErrorCode.TX_EXIST, new String[]{"--", txHash});
        }
        try {
            if (this.transactionService.hadTxExist(chainId, txHash)) {
                return ValidateResult.getResult(LedgerErrorCode.TX_EXIST, new String[]{"--", txHash});
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{"--", txHash, "unknown error"});
        }
        CoinData coinData = CoinDataUtil.parseCoinData(tx.getCoinData());
        if (null == coinData) {
            batchValidateTxMap.put(txHash, txHash);
            return ValidateResult.getSuccess();
        }
        if (!this.validateTxAmount(coinData, txType)) {
            return ValidateResult.getResult(LedgerErrorCode.TX_AMOUNT_INVALIDATE, new String[]{txHash});
        }
        List coinFroms = coinData.getFrom();
        List coinTos = coinData.getTo();
        byte[] nonce8Bytes = LedgerUtil.getNonceByTx(tx);
        if (LoggerUtil.logger(chainId).isDebugEnabled()) {
            LoggerUtil.logger(chainId).debug("[TEST] confirmedTxValidate txType: {}, txHash: {}, nonce: {}", new Object[]{txType, txHash, HexUtil.encode((byte[])nonce8Bytes)});
        }
        Map<String, List<FreezeLockTimeState>> timeStatesMap = this.getFreezeLockTimeValidateMap(chainId);
        Map<String, List<FreezeHeightState>> heightStatesMap = this.getFreezeLockHeightValidateMap(chainId);
        ValidateResult validateResult = this.analysisFromCoinPerTx(chainId, txType, tx.getBlockHeight(), nonce8Bytes, coinFroms, accountValidateTxMap, accountStateMap, balanceValidateMap);
        if (!validateResult.isSuccess()) {
            return validateResult;
        }
        ValidateResult toCoinValidateResult = this.analysisToCoinPerTx(chainId, txType, coinTos, accountStateMap, timeStatesMap, heightStatesMap, balanceValidateMap);
        if (!toCoinValidateResult.isSuccess()) {
            return validateResult;
        }
        for (Map.Entry entry : balanceValidateMap.entrySet()) {
            if (!BigIntegerUtils.isLessThan((BigInteger)((BigInteger)entry.getValue()), (BigInteger)BigInteger.ZERO)) continue;
            LoggerUtil.logger(chainId).info("balance is not enough:{}===availableAmount={}", new Object[]{entry.getKey(), entry.getValue()});
            return ValidateResult.getResult(LedgerErrorCode.BALANCE_NOT_ENOUGH, new String[]{(String)entry.getKey(), BigIntegerUtils.bigIntegerToString((BigInteger)((BigInteger)entry.getValue()))});
        }
        int length = coinFroms.size();
        for (int i = 0; i < length; ++i) {
            CoinFrom coinFrom = (CoinFrom)coinFroms.get(i);
            String address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
            if (LedgerUtil.isNotLocalChainAccount(chainId, coinFrom.getAddress()) && LedgerUtil.isCrossTx(txType)) continue;
            String assetKey = LedgerUtil.getKeyStr(address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            AccountState accountState = accountStateMap.get(assetKey);
            List<FreezeLockTimeState> timeStates = this.getFreezeLockTimeValidateList(timeStatesMap, assetKey);
            List<FreezeHeightState> heightStates = this.getFreezeLockHeightValidateList(heightStatesMap, assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeStates.addAll(accountState.getFreezeLockTimeStates());
                heightStates.addAll(accountState.getFreezeHeightStates());
            }
            if (coinFrom.getLocked() == 0) {
                List list = accountValidateTxMap.computeIfAbsent(assetKey, a -> new ArrayList());
                list.add(new TempAccountNonce(assetKey, coinFrom.getNonce(), nonce8Bytes));
                accountState.addTotalFromAmount(coinFrom.getAmount());
                continue;
            }
            this.txLockedProcessor.processCoinData((Coin)coinFrom, coinFrom.getNonce(), txHash, timeStates, heightStates, address, true);
        }
        for (CoinTo coinTo : coinTos) {
            String address = LedgerUtil.getRealAddressStr(coinTo.getAddress());
            String assetKey = LedgerUtil.getKeyStr(address, coinTo.getAssetsChainId(), coinTo.getAssetsId());
            AccountState accountState = accountStateMap.get(assetKey);
            List<FreezeLockTimeState> timeList = this.getFreezeLockTimeValidateList(timeStatesMap, assetKey);
            List<FreezeHeightState> heightList = this.getFreezeLockHeightValidateList(heightStatesMap, assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinTo.getAssetsChainId(), coinTo.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeList.addAll(accountState.getFreezeLockTimeStates());
                heightList.addAll(accountState.getFreezeHeightStates());
            }
            if (coinTo.getLockTime() == 0L) {
                accountState.addTotalToAmount(coinTo.getAmount());
                continue;
            }
            this.txLockedProcessor.processCoinData((Coin)coinTo, LedgerUtil.getNonceDecodeByTxHash(txHash), txHash, timeList, heightList, address, false);
        }
        batchValidateTxMap.put(txHash, txHash);
        return ValidateResult.getSuccess();
    }

    private ValidateResult validateCommonCoinData(int addressChainId, int assetChainId, int assetId, AccountState accountState, String address, BigInteger fromAmount, byte[] fromNonce, byte[] txNonce, boolean containUncomfirmedAmount) {
        AccountStateUnconfirmed accountStateUnconfirmed = null;
        accountStateUnconfirmed = containUncomfirmedAmount ? this.unconfirmedStateService.getUnconfirmedInfo(address, addressChainId, assetChainId, assetId, accountState) : this.unconfirmedStateService.getUnconfirmedJustNonce(address, addressChainId, assetChainId, assetId, accountState);
        byte[] preNonce = null;
        BigInteger amount = BigInteger.ZERO;
        if (null == accountStateUnconfirmed) {
            preNonce = accountState.getNonce();
            amount = accountState.getAvailableAmount();
        } else {
            preNonce = accountStateUnconfirmed.getNonce();
            amount = accountState.getAvailableAmount().subtract(accountStateUnconfirmed.getAmount());
        }
        String fromNonceStr = LedgerUtil.getNonceEncode(fromNonce);
        if (LedgerUtil.equalsNonces(fromNonce, preNonce)) {
            if (BigIntegerUtils.isLessThan((BigInteger)amount, (BigInteger)fromAmount)) {
                LoggerUtil.logger(addressChainId).error("dbAmount={},fromAmount={},balance is not enough", new Object[]{BigIntegerUtils.bigIntegerToString((BigInteger)amount), BigIntegerUtils.bigIntegerToString((BigInteger)fromAmount)});
                return ValidateResult.getResult(LedgerErrorCode.BALANCE_NOT_ENOUGH, new String[]{address + "-" + assetChainId + "-" + assetId, BigIntegerUtils.bigIntegerToString((BigInteger)amount.subtract(fromAmount))});
            }
            return ValidateResult.getSuccess();
        }
        try {
            if (LedgerUtil.equalsNonces(fromNonce, LedgerConstant.getInitNonceByte())) {
                LoggerUtil.logger(addressChainId).info("DOUBLE_EXPENSES_CODE address={},fromNonceStr={},dbNonce={},tx={}", new Object[]{address, fromNonceStr, LedgerUtil.getNonceEncode(preNonce), LedgerUtil.getNonceEncode(txNonce)});
                return ValidateResult.getResult(LedgerErrorCode.DOUBLE_EXPENSES, new String[]{address, fromNonceStr});
            }
            if (LedgerUtil.equalsNonces(preNonce, txNonce)) {
                LoggerUtil.logger(addressChainId).info("DOUBLE_EXPENSES_CODE address={},fromNonceStr={},dbNonce={},tx={}", new Object[]{address, fromNonceStr, LedgerUtil.getNonceEncode(preNonce), LedgerUtil.getNonceEncode(txNonce)});
                return ValidateResult.getResult(LedgerErrorCode.DOUBLE_EXPENSES, new String[]{address, fromNonceStr});
            }
            if (this.transactionService.fromNonceExist(addressChainId, LedgerUtil.getAccountNoncesStrKey(address, assetChainId, assetId, fromNonceStr))) {
                LoggerUtil.logger(addressChainId).info("DOUBLE_EXPENSES_CODE address={},fromNonceStr={},tx={} fromNonce exist", new Object[]{address, fromNonceStr, LedgerUtil.getNonceEncode(txNonce)});
                return ValidateResult.getResult(LedgerErrorCode.DOUBLE_EXPENSES, new String[]{address, fromNonceStr});
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, fromNonceStr, "exception:" + e.getMessage()});
        }
        return ValidateResult.getResult(LedgerErrorCode.ORPHAN, new String[]{address, fromNonceStr, LedgerUtil.getNonceEncode(preNonce)});
    }

    private ValidateResult isValidateCommonTxBatch(int chainId, AccountState accountState, CoinFrom coinFrom, byte[] txNonce, Map<String, List<TempAccountNonce>> accountValidateTxMap) {
        String address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
        String assetKey = LedgerUtil.getKeyStr(address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
        String fromCoinNonceStr = LedgerUtil.getNonceEncode(coinFrom.getNonce());
        if (LedgerUtil.equalsNonces(coinFrom.getNonce(), txNonce)) {
            LoggerUtil.logger(chainId).info("{}=={}=={}== nonce is repeat", new Object[]{address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId()});
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, fromCoinNonceStr, "nonce repeat"});
        }
        List<TempAccountNonce> list = accountValidateTxMap.get(assetKey);
        if (null == list || list.isEmpty()) {
            if (!LedgerUtil.equalsNonces(accountState.getNonce(), coinFrom.getNonce())) {
                LoggerUtil.logger(chainId).error("package validate fail(validateCommonTxBatch):{}=={}=={}==nonce is error!dbNonce:{}!=fromNonce:{},tx={}", new Object[]{address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), LedgerUtil.getNonceEncode(accountState.getNonce()), fromCoinNonceStr, LedgerUtil.getNonceEncode(txNonce)});
                return ValidateResult.getResult(LedgerErrorCode.ORPHAN, new String[]{address, fromCoinNonceStr, LedgerUtil.getNonceEncode(accountState.getNonce())});
            }
        } else {
            TempAccountNonce tempAccountState = list.get(list.size() - 1);
            if (!LedgerUtil.equalsNonces(tempAccountState.getNextNonce(), coinFrom.getNonce())) {
                LoggerUtil.logger(chainId).error("package validate fail(validateCommonTxBatch):{}=={}=={}==nonce is error!tempNonce:{}!=fromNonce:{},tx={}", new Object[]{address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), LedgerUtil.getNonceEncode(tempAccountState.getNextNonce()), fromCoinNonceStr, LedgerUtil.getNonceEncode(txNonce)});
                return ValidateResult.getResult(LedgerErrorCode.ORPHAN, new String[]{address, fromCoinNonceStr, "last pool nonce=" + LedgerUtil.getNonceEncode(tempAccountState.getNextNonce())});
            }
        }
        return ValidateResult.getSuccess();
    }

    private ValidateResult analysisFromCoinBlokTx(int chainId, int txType, long blockHeight, byte[] txNonce, List<CoinFrom> coinFroms, Map<String, List<TempAccountNonce>> accountValidateTxMap, Map<String, AccountState> accountStateMap, Map<String, Object> lockedCancelNonceMap, Map<String, List<FreezeLockTimeState>> timeLockMap, Map<String, List<FreezeHeightState>> heightLockMap, String txHash, Map<String, BigInteger> balanceValidateMap) {
        long hardForkingHeight = 878000L;
        boolean forked = blockHeight <= 0L || blockHeight > hardForkingHeight;
        for (CoinFrom coinFrom : coinFroms) {
            String address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
            if (LedgerUtil.isNotLocalChainAccount(chainId, coinFrom.getAddress())) {
                if (LedgerUtil.isCrossTx(txType)) continue;
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, "--", "address Not local chain Exception"});
            }
            if (AddressTool.isBlackHoleAddress((byte[])LedgerConstant.blackHolePublicKey, (int)chainId, (byte[])coinFrom.getAddress())) {
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "address is blackHoleAddress Exception"});
            }
            if (forked && LedgerUtil.isBlackHoleAddress(chainId, coinFrom.getAddress())) {
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "address is blackHoleAddress Exception[x]"});
            }
            String assetKey = LedgerUtil.getKeyStr(address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            AccountState accountState = accountStateMap.get(assetKey);
            List<FreezeLockTimeState> timeList = this.getFreezeLockTimeValidateList(timeLockMap, assetKey);
            List<FreezeHeightState> heightList = this.getFreezeLockHeightValidateList(heightLockMap, assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeList.addAll(accountState.getFreezeLockTimeStates());
                heightList.addAll(accountState.getFreezeHeightStates());
            }
            BigInteger availableAmount = accountState.getAvailableAmount();
            balanceValidateMap.computeIfAbsent(assetKey, a -> availableAmount);
            if (coinFrom.getLocked() == 0) {
                String fromCoinNonce = LedgerUtil.getNonceEncode(coinFrom.getNonce());
                if (LedgerUtil.equalsNonces(coinFrom.getNonce(), txNonce)) {
                    LoggerUtil.logger(chainId).info("{}=={}=={}== nonce is repeat", new Object[]{address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId()});
                    return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, fromCoinNonce, "nonce repeat"});
                }
                List<TempAccountNonce> list = accountValidateTxMap.get(assetKey);
                if (null == list || list.isEmpty()) {
                    if (!LedgerUtil.equalsNonces(accountState.getNonce(), coinFrom.getNonce())) {
                        LoggerUtil.logger(chainId).error("validate fail:(isBlockValidateCommonTx failed)\uff1a{}=={}=={}==nonce is error!dbNonce:{}!=fromNonce:{},tx={}", new Object[]{address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), LedgerUtil.getNonceEncode(accountState.getNonce()), fromCoinNonce, LedgerUtil.getNonceEncode(txNonce)});
                        LoggerUtil.logger(chainId).error("txType:{}, hash:{}", new Object[]{txType, txHash});
                        return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, fromCoinNonce, "dbNonce=" + LedgerUtil.getNonceEncode(accountState.getNonce())});
                    }
                } else {
                    TempAccountNonce tempAccountState = list.get(list.size() - 1);
                    if (!LedgerUtil.equalsNonces(tempAccountState.getNextNonce(), coinFrom.getNonce())) {
                        LoggerUtil.logger(chainId).info("isValidateCommonTxBatch {}=={}=={}==nonce is error!tempNonce:{}!=fromNonce:{},tx={}", new Object[]{address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), LedgerUtil.getNonceEncode(tempAccountState.getNextNonce()), fromCoinNonce, LedgerUtil.getNonceEncode(txNonce)});
                        return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, fromCoinNonce, "last pool nonce=" + LedgerUtil.getNonceEncode(tempAccountState.getNextNonce())});
                    }
                }
                balanceValidateMap.computeIfPresent(assetKey, (k, v) -> v.subtract(coinFrom.getAmount()));
                continue;
            }
            String lockedNonce = coinFrom.getAssetsChainId() + "-" + coinFrom.getAssetsId() + "-" + LedgerUtil.getNonceEncode(coinFrom.getNonce());
            if (!this.isValidateFreezeTxWithTemp(timeList, heightList, coinFrom.getLocked(), coinFrom.getAmount(), coinFrom.getNonce())) {
                LoggerUtil.logger(chainId).error("validate fail,locked tx={} address={} lockNonce={} failed", new Object[]{LedgerUtil.getNonceEncode(txNonce), address, lockedNonce});
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, lockedNonce, "validate fail"});
            }
            if (null == lockedCancelNonceMap.get(lockedNonce)) continue;
            LoggerUtil.logger(chainId).error("validate fail,locked tx={} address={} nonce={} repeat", new Object[]{LedgerUtil.getNonceEncode(txNonce), address, lockedNonce});
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, lockedNonce, "validate fail,locked nonce repeat"});
        }
        return ValidateResult.getSuccess();
    }

    public ValidateResult blockTxsValidate(int chainId, Transaction tx, Set<String> batchValidateTxSet, Map<String, List<TempAccountNonce>> accountValidateTxMap, Map<String, AccountState> accountStateMap, Map<String, Object> lockedCancelNonceMap, Map<String, List<FreezeLockTimeState>> lockedTimeMap, Map<String, List<FreezeHeightState>> lockedHeightMap) {
        List<FreezeHeightState> heightList;
        List<FreezeLockTimeState> timeList;
        AccountState accountState;
        String assetKey;
        String address;
        String txHash = tx.getHash().toHex();
        int txType = tx.getType();
        if (batchValidateTxSet.contains(txHash)) {
            LoggerUtil.logger(chainId).error("{} tx exist!", new Object[]{txHash});
            return ValidateResult.getResult(LedgerErrorCode.TX_EXIST, new String[]{"--", txHash});
        }
        try {
            if (this.transactionService.hadTxExist(chainId, txHash)) {
                LoggerUtil.logger(chainId).error("{} tx exist!", new Object[]{txHash});
                return ValidateResult.getResult(LedgerErrorCode.TX_EXIST, new String[]{"--", txHash});
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
        }
        CoinData coinData = CoinDataUtil.parseCoinData(tx.getCoinData());
        if (null == coinData) {
            batchValidateTxSet.add(txHash);
            return ValidateResult.getSuccess();
        }
        if (!this.validateTxAmount(coinData, txType)) {
            return ValidateResult.getResult(LedgerErrorCode.TX_AMOUNT_INVALIDATE, new String[]{txHash});
        }
        HashMap<String, BigInteger> balanceValidateMap = new HashMap<String, BigInteger>(64);
        List coinFroms = coinData.getFrom();
        List coinTos = coinData.getTo();
        byte[] txNonce = LedgerUtil.getNonceByTx(tx);
        ValidateResult fromCoinsValidateResult = this.analysisFromCoinBlokTx(chainId, txType, tx.getBlockHeight(), txNonce, coinFroms, accountValidateTxMap, accountStateMap, lockedCancelNonceMap, lockedTimeMap, lockedHeightMap, txHash, balanceValidateMap);
        if (!fromCoinsValidateResult.isSuccess()) {
            LoggerUtil.logger(chainId).error("from coins error! txtype:{}", new Object[]{txType});
            return fromCoinsValidateResult;
        }
        ValidateResult toCoinValidateResult = this.analysisToCoinPerTx(chainId, txType, coinTos, accountStateMap, lockedTimeMap, lockedHeightMap, balanceValidateMap);
        if (!toCoinValidateResult.isSuccess()) {
            LoggerUtil.logger(chainId).error("to coins error!");
            return toCoinValidateResult;
        }
        for (Map.Entry entry : balanceValidateMap.entrySet()) {
            if (!BigIntegerUtils.isLessThan((BigInteger)((BigInteger)entry.getValue()), (BigInteger)BigInteger.ZERO)) continue;
            LoggerUtil.logger(chainId).info("balance is not enough:{}===availableAmount={}", new Object[]{entry.getKey(), entry.getValue()});
            return ValidateResult.getResult(LedgerErrorCode.BALANCE_NOT_ENOUGH, new String[]{(String)entry.getKey(), BigIntegerUtils.bigIntegerToString((BigInteger)((BigInteger)entry.getValue()))});
        }
        for (CoinFrom coinFrom : coinFroms) {
            address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
            if (LedgerUtil.isNotLocalChainAccount(chainId, coinFrom.getAddress()) && LedgerUtil.isCrossTx(txType)) continue;
            assetKey = LedgerUtil.getKeyStr(address, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            accountState = accountStateMap.get(assetKey);
            timeList = this.getFreezeLockTimeValidateList(lockedTimeMap, assetKey);
            heightList = this.getFreezeLockHeightValidateList(lockedHeightMap, assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeList.addAll(accountState.getFreezeLockTimeStates());
                heightList.addAll(accountState.getFreezeHeightStates());
            }
            if (coinFrom.getLocked() == 0) {
                accountState.addTotalFromAmount(coinFrom.getAmount());
                List list = accountValidateTxMap.computeIfAbsent(assetKey, a -> new ArrayList());
                list.add(new TempAccountNonce(assetKey, coinFrom.getNonce(), txNonce));
                continue;
            }
            String lockedNonce = coinFrom.getAssetsChainId() + "-" + coinFrom.getAssetsId() + "-" + LedgerUtil.getNonceEncode(coinFrom.getNonce());
            lockedCancelNonceMap.put(lockedNonce, 1);
            this.txLockedProcessor.processCoinData((Coin)coinFrom, coinFrom.getNonce(), txHash, timeList, heightList, address, true);
        }
        for (CoinTo coinTo : coinTos) {
            address = LedgerUtil.getRealAddressStr(coinTo.getAddress());
            assetKey = LedgerUtil.getKeyStr(address, coinTo.getAssetsChainId(), coinTo.getAssetsId());
            accountState = accountStateMap.get(assetKey);
            timeList = this.getFreezeLockTimeValidateList(lockedTimeMap, assetKey);
            heightList = this.getFreezeLockHeightValidateList(lockedHeightMap, assetKey);
            if (null == accountState) {
                accountState = this.accountStateService.getAccountStateReCal(address, chainId, coinTo.getAssetsChainId(), coinTo.getAssetsId());
                accountStateMap.put(assetKey, accountState);
                timeList.addAll(accountState.getFreezeLockTimeStates());
                heightList.addAll(accountState.getFreezeHeightStates());
            }
            if (coinTo.getLockTime() == 0L) {
                accountState.addTotalToAmount(coinTo.getAmount());
                continue;
            }
            this.txLockedProcessor.processCoinData((Coin)coinTo, LedgerUtil.getNonceDecodeByTxHash(txHash), txHash, timeList, heightList, address, false);
        }
        batchValidateTxSet.add(txHash);
        return ValidateResult.getSuccess();
    }

    private boolean isValidateFreezeTx(byte locked, AccountState accountState, BigInteger fromAmount, byte[] fromNonce) {
        boolean isValidate;
        block2: {
            block3: {
                isValidate = false;
                if (locked != -1) break block3;
                List<FreezeLockTimeState> list = accountState.getFreezeLockTimeStates();
                for (FreezeLockTimeState freezeLockTimeState : list) {
                    if (!LedgerUtil.equalsNonces(freezeLockTimeState.getNonce(), fromNonce) || freezeLockTimeState.getAmount().compareTo(fromAmount) != 0) continue;
                    isValidate = true;
                    break block2;
                }
                break block2;
            }
            if (locked != 1) break block2;
            List<FreezeHeightState> list = accountState.getFreezeHeightStates();
            for (FreezeHeightState freezeHeightState : list) {
                if (!LedgerUtil.equalsNonces(freezeHeightState.getNonce(), fromNonce) || freezeHeightState.getAmount().compareTo(fromAmount) != 0) continue;
                isValidate = true;
                break;
            }
        }
        return isValidate;
    }

    private boolean isValidateFreezeTxWithTemp(List<FreezeLockTimeState> timeList, List<FreezeHeightState> heightList, byte locked, BigInteger fromAmount, byte[] fromNonce) {
        boolean isValidate;
        block3: {
            block4: {
                isValidate = false;
                if (locked != -1) break block4;
                if (null == timeList) break block3;
                for (FreezeLockTimeState freezeLockTimeState : timeList) {
                    if (!LedgerUtil.equalsNonces(freezeLockTimeState.getNonce(), fromNonce) || freezeLockTimeState.getAmount().compareTo(fromAmount) != 0) continue;
                    isValidate = true;
                    break block3;
                }
                break block3;
            }
            if (locked == 1 && null != heightList) {
                for (FreezeHeightState freezeHeightState : heightList) {
                    if (!LedgerUtil.equalsNonces(freezeHeightState.getNonce(), fromNonce) || freezeHeightState.getAmount().compareTo(fromAmount) != 0) continue;
                    isValidate = true;
                    break;
                }
            }
        }
        return isValidate;
    }

    public ValidateResult validateCoinData(int addressChainId, Transaction tx) throws Exception {
        String txHash = tx.getHash().toHex();
        byte[] txNonce = LedgerUtil.getNonceByTx(tx);
        if (this.transactionService.hadTxExist(addressChainId, txHash)) {
            return ValidateResult.getResult(LedgerErrorCode.TX_EXIST, new String[]{"--", txHash});
        }
        CoinData coinData = CoinDataUtil.parseCoinData(tx.getCoinData());
        if (null == coinData) {
            return ValidateResult.getSuccess();
        }
        if (!this.validateTxAmount(coinData, tx.getType())) {
            return ValidateResult.getResult(LedgerErrorCode.TX_AMOUNT_INVALIDATE, new String[]{txHash});
        }
        List coinFroms = coinData.getFrom();
        for (CoinFrom coinFrom : coinFroms) {
            if (LedgerUtil.isNotLocalChainAccount(addressChainId, coinFrom.getAddress())) {
                if (LedgerUtil.isCrossTx(tx.getType())) continue;
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{LedgerUtil.getRealAddressStr(coinFrom.getAddress()), "--", "address Not local chain Exception"});
            }
            String address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
            AccountState accountState = this.accountStateService.getAccountStateReCal(address, addressChainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            if (coinFrom.getLocked() == 0) {
                return this.validateCommonCoinData(addressChainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), accountState, address, coinFrom.getAmount(), coinFrom.getNonce(), txNonce, true);
            }
            if (this.isValidateFreezeTx(coinFrom.getLocked(), accountState, coinFrom.getAmount(), coinFrom.getNonce())) continue;
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "freeze tx is not exist"});
        }
        return ValidateResult.getSuccess();
    }

    public ValidateResult analysisCoinData(int addressChainId, Transaction tx, Map<String, TxUnconfirmed> accountsMap, byte[] txNonce) throws Exception {
        String txHash = tx.getHash().toHex();
        if (this.transactionService.hadTxExist(addressChainId, txHash)) {
            return ValidateResult.getResult(LedgerErrorCode.TX_EXIST, new String[]{"--", txHash});
        }
        CoinData coinData = CoinDataUtil.parseCoinData(tx.getCoinData());
        if (null == coinData) {
            return ValidateResult.getSuccess();
        }
        List coinFroms = coinData.getFrom();
        for (CoinFrom coinFrom : coinFroms) {
            if (LedgerUtil.isNotLocalChainAccount(addressChainId, coinFrom.getAddress())) {
                if (LedgerUtil.isCrossTx(tx.getType())) continue;
                return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{LedgerUtil.getRealAddressStr(coinFrom.getAddress()), "--", "address Not local chain Exception"});
            }
            String address = LedgerUtil.getRealAddressStr(coinFrom.getAddress());
            int assetChainId = coinFrom.getAssetsChainId();
            int assetId = coinFrom.getAssetsId();
            String accountKey = LedgerUtil.getKeyStr(address, assetChainId, assetId);
            AccountState accountState = this.accountStateService.getAccountStateReCal(address, addressChainId, coinFrom.getAssetsChainId(), coinFrom.getAssetsId());
            if (coinFrom.getLocked() == 0) {
                ValidateResult validateResult = this.validateCommonCoinData(addressChainId, assetChainId, assetId, accountState, address, coinFrom.getAmount(), coinFrom.getNonce(), txNonce, false);
                if (validateResult.isSuccess()) {
                    CoinDataUtil.calTxFromAmount(accountsMap, coinFrom, txNonce, accountKey, address);
                    continue;
                }
                return validateResult;
            }
            if (this.isValidateFreezeTx(coinFrom.getLocked(), accountState, coinFrom.getAmount(), coinFrom.getNonce())) continue;
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{address, LedgerUtil.getNonceEncode(coinFrom.getNonce()), "freeze tx is not exist"});
        }
        return ValidateResult.getSuccess();
    }

    public boolean rollbackTxValidateStatus(int chainId, Transaction tx) {
        Map<String, List<TempAccountNonce>> accountBalanceValidateTxMap = this.getAccountBalanceValidateMap(chainId);
        String txHash = tx.getHash().toHex();
        if (null == this.chainsBatchValidateTxMap.get(txHash)) {
            LoggerUtil.logger(chainId).info("{} tx not exist!", new Object[]{txHash});
            return true;
        }
        CoinData coinData = CoinDataUtil.parseCoinData(tx.getCoinData());
        if (null == coinData) {
            this.chainsBatchValidateTxMap.remove(txHash);
            return true;
        }
        List coinFroms = coinData.getFrom();
        byte[] nonce8Bytes = LedgerUtil.getNonceByTx(tx);
        for (CoinFrom coinFrom : coinFroms) {
            TempAccountNonce tempAccountState;
            String assetKey;
            List<TempAccountNonce> list;
            if (LedgerUtil.isNotLocalChainAccount(chainId, coinFrom.getAddress())) {
                if (LedgerUtil.isCrossTx(tx.getType())) continue;
                LoggerUtil.logger(chainId).error("address={} Not local chain Exception", new Object[]{LedgerUtil.getRealAddressStr(coinFrom.getAddress())});
                return false;
            }
            if (coinFrom.getLocked() != 0 || null == (list = accountBalanceValidateTxMap.get(assetKey = LedgerUtil.getKeyStr(LedgerUtil.getRealAddressStr(coinFrom.getAddress()), coinFrom.getAssetsChainId(), coinFrom.getAssetsId()))) || !LedgerUtil.equalsNonces((tempAccountState = list.get(list.size() - 1)).getNextNonce(), nonce8Bytes)) continue;
            list.remove(list.size() - 1);
        }
        this.chainsBatchValidateTxMap.remove(txHash);
        return true;
    }

    public boolean validateTxAmount(CoinData coinData, int txType) {
        if (txType == 19 || txType == 1) {
            return true;
        }
        HashMap<CallSite, BigInteger> assetMap = new HashMap<CallSite, BigInteger>();
        ArrayList<CallSite> assetKeys = new ArrayList<CallSite>();
        List froms = coinData.getFrom();
        for (Object from : froms) {
            String fromKey;
            String assetKey = from.getAssetsChainId() + "_" + from.getAssetsId();
            if (null == assetMap.get(assetKey)) {
                assetMap.put((CallSite)((Object)assetKey), BigInteger.ZERO);
                assetKeys.add((CallSite)((Object)assetKey));
            }
            if (null == assetMap.get(fromKey = assetKey + "from")) {
                assetMap.put((CallSite)((Object)fromKey), from.getAmount());
                continue;
            }
            BigInteger bigInteger = ((BigInteger)assetMap.get(fromKey)).add(from.getAmount());
            assetMap.put((CallSite)((Object)fromKey), bigInteger);
        }
        List tos = coinData.getTo();
        for (CoinTo to : tos) {
            String string;
            String assetKey = to.getAssetsChainId() + "_" + to.getAssetsId();
            if (null == assetMap.get(assetKey)) {
                assetMap.put((CallSite)((Object)assetKey), BigInteger.ZERO);
                assetKeys.add((CallSite)((Object)assetKey));
            }
            if (null == assetMap.get(string = assetKey + "to")) {
                assetMap.put((CallSite)((Object)string), to.getAmount());
                continue;
            }
            BigInteger fromAmount = ((BigInteger)assetMap.get(string)).add(to.getAmount());
            assetMap.put((CallSite)((Object)string), fromAmount);
        }
        for (String string : assetKeys) {
            BigInteger assetKeyFrom = (BigInteger)assetMap.get(string + "from");
            BigInteger assetKeyTo = (BigInteger)assetMap.get(string + "to");
            if (null == assetKeyFrom) {
                LoggerUtil.COMMON_LOG.error("asset From is null,txType={}", new Object[]{txType});
                return false;
            }
            if (null == assetKeyTo || !BigIntegerUtils.isLessThan((BigInteger)assetKeyFrom, (BigInteger)assetKeyTo)) continue;
            LoggerUtil.COMMON_LOG.error("fromAmount is less than to amount");
            return false;
        }
        return true;
    }
}

