/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.thread.ThreadUtils;
import io.nuls.core.thread.commom.NulsThreadFactory;
import io.nuls.network.constant.ManagerStatusEnum;
import io.nuls.network.manager.BaseManager;
import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.StorageManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.message.VersionMessage;
import io.nuls.network.model.po.GroupNodesPo;
import io.nuls.network.netty.NettyClient;
import io.nuls.network.netty.NettyServer;
import io.nuls.network.netty.container.NodesContainer;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public class ConnectionManager
extends BaseManager {
    NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
    NettyServer server = null;
    NettyServer serverCross = null;
    private static ConnectionManager instance = new ConnectionManager();
    private Map<String, Node> cacheConnectNodeInMap = new ConcurrentHashMap<String, Node>();
    private Map<String, Node> cacheConnectNodeOutMap = new ConcurrentHashMap<String, Node>();
    public ExecutorService discover = ThreadUtils.createThreadPool((int)Runtime.getRuntime().availableProcessors(), (int)20, (NulsThreadFactory)new NulsThreadFactory("NODE_DISCOVER_MULTI_THREAD"));
    public ExecutorService maintenance = ThreadUtils.createThreadPool((int)Runtime.getRuntime().availableProcessors(), (int)20, (NulsThreadFactory)new NulsThreadFactory("NODE_MAINTENANCE_MULTI_THREAD"));
    private StorageManager storageManager = StorageManager.getInstance();
    private ManagerStatusEnum status = ManagerStatusEnum.UNINITIALIZED;

    public static ConnectionManager getInstance() {
        return instance;
    }

    private ConnectionManager() {
    }

    public void nodeConnectFail(Node node) {
        node.setStatus(3);
        node.setConnectStatus(4);
        node.setFailCount(node.getFailCount() + 1);
        node.setLastProbeTime(TimeManager.currentTimeMillis());
    }

    public boolean isRunning() {
        return ConnectionManager.instance.status == ManagerStatusEnum.RUNNING;
    }

    private void loadSeedsNode() {
        List<String> list = this.networkConfig.getSeedIpList();
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByMagic(this.networkConfig.getPacketMagic());
        for (String seed : list) {
            String[] peer = IpUtil.splitHostPort(seed);
            if (IpUtil.getIps().contains(peer[0])) continue;
            Node node = new Node(nodeGroup.getMagicNumber(), peer[0], Integer.valueOf(peer[1]), 0, 2, false);
            node.setConnectStatus(0);
            node.setSeedNode(true);
            node.setStatus(2);
            nodeGroup.getLocalNetNodeContainer().getCanConnectNodes().put(node.getId(), node);
            nodeGroup.getLocalNetNodeContainer().getUncheckNodes().remove(node.getId());
            nodeGroup.getLocalNetNodeContainer().getDisconnectNodes().remove(node.getId());
            nodeGroup.getLocalNetNodeContainer().getFailNodes().remove(node.getId());
        }
    }

    public void nodeClientConnectSuccess(Node node) {
        NodeGroup nodeGroup = node.getNodeGroup();
        NodesContainer nodesContainer = null;
        nodesContainer = node.isCrossConnect() ? nodeGroup.getCrossNodeContainer() : nodeGroup.getLocalNetNodeContainer();
        nodesContainer.getConnectedNodes().put(node.getId(), node);
        nodesContainer.getCanConnectNodes().remove(node.getId());
        node.setConnectStatus(2);
        LoggerUtil.logger(nodeGroup.getChainId()).debug("client node {} connect success !", new Object[]{node.getId()});
        VersionMessage versionMessage = MessageFactory.getInstance().buildVersionMessage(node, nodeGroup.getMagicNumber());
        MessageManager.getInstance().sendHandlerMsg(versionMessage, node, true);
    }

    private void cacheNode(Node node, SocketChannel channel) {
        String name = "node-" + node.getId();
        boolean exists = AttributeKey.exists((String)name);
        AttributeKey attributeKey = exists ? AttributeKey.valueOf((String)name) : AttributeKey.newInstance((String)name);
        Attribute attribute = channel.attr(attributeKey);
        attribute.set((Object)node);
    }

    public boolean nodeConnectIn(String ip, int port, SocketChannel channel) {
        boolean isCross = false;
        if (channel.localAddress().getPort() == this.networkConfig.getCrossPort()) {
            isCross = true;
        }
        if (!this.isRunning()) {
            LoggerUtil.COMMON_LOG.debug("ConnectionManager is stop,refuse peer = {}:{} connectIn isCross={}", new Object[]{ip, port, isCross});
            return false;
        }
        LoggerUtil.COMMON_LOG.debug("peer = {}:{} connectIn isCross={}", new Object[]{ip, port, isCross});
        Node node = new Node(0L, ip, port, 0, 1, isCross);
        node.setConnectStatus(2);
        node.setChannel((Channel)channel);
        this.cacheNode(node, channel);
        return true;
    }

    public void nodeConnectDisconnect(Node node) {
        if (node.getChannel() != null) {
            node.setChannel(null);
        }
        NodeGroup nodeGroup = node.getNodeGroup();
        NodesContainer nodesContainer = null;
        nodesContainer = node.isCrossConnect() ? nodeGroup.getCrossNodeContainer() : nodeGroup.getLocalNetNodeContainer();
        if (node.getConnectStatus() == 5) {
            node.setFailCount(0);
            node.setHadShare(false);
            node.setConnectStatus(3);
            nodesContainer.getDisconnectNodes().put(node.getId(), node);
            nodesContainer.getConnectedNodes().remove(node.getId());
        } else {
            if (node.getConnectStatus() == 2) {
                nodesContainer.getConnectedNodes().remove(node.getId());
            }
            this.nodeConnectFail(node);
            nodesContainer.getCanConnectNodes().remove(node.getId());
            nodesContainer.getFailNodes().put(node.getId(), node);
        }
    }

    private void nettyBoot() {
        this.serverStart();
        Log.info((String)"==========================NettyServerBoot");
    }

    private void serverStart() {
        this.server = new NettyServer(this.networkConfig.getPort());
        this.serverCross = new NettyServer(this.networkConfig.getCrossPort());
        this.server.init();
        this.serverCross.init();
        ThreadUtils.createAndRunThread((String)"node server start", () -> {
            try {
                this.server.start();
            }
            catch (InterruptedException e) {
                Log.error((String)e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }, (boolean)false);
        ThreadUtils.createAndRunThread((String)"node crossServer start", () -> {
            try {
                this.serverCross.start();
            }
            catch (InterruptedException e) {
                Log.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }, (boolean)false);
    }

    public boolean connection(Node node) {
        try {
            NettyClient client = new NettyClient(node);
            return client.start();
        }
        catch (Exception e) {
            Log.error((String)"connect to node {} error : {}", (Object[])new Object[]{node.getId(), e.getMessage()});
            return false;
        }
    }

    @Override
    public void init() throws Exception {
        this.status = ManagerStatusEnum.INITIALIZED;
        Collection<NodeGroup> nodeGroups = NodeGroupManager.getInstance().getNodeGroupCollection();
        for (NodeGroup nodeGroup : nodeGroups) {
            if (!nodeGroup.isMoonCrossGroup()) {
                this.loadSeedsNode();
            }
            GroupNodesPo groupNodesPo = this.storageManager.getNodesByChainId(nodeGroup.getChainId());
            nodeGroup.loadNodes(groupNodesPo);
        }
    }

    @Override
    public void start() throws Exception {
        while (!ConnectManager.isReady()) {
            Log.debug((String)"wait depend modules ready");
            Thread.sleep(2000L);
        }
        this.nettyBoot();
        this.status = ManagerStatusEnum.RUNNING;
    }

    @Override
    public void change(ManagerStatusEnum toStatus) throws Exception {
        this.status = toStatus;
        if (toStatus == ManagerStatusEnum.STOPED || toStatus == ManagerStatusEnum.RUNNING) {
            // empty if block
        }
    }
}

