/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.MessageHandlerFactory;
import io.nuls.network.manager.handler.base.BaseMeesageHandlerInf;
import io.nuls.network.manager.handler.message.AddrMessageHandler;
import io.nuls.network.manager.handler.message.GetAddrMessageHandler;
import io.nuls.network.manager.handler.message.GetTimeMessageHandler;
import io.nuls.network.manager.handler.message.PeerInfoMessageHandler;
import io.nuls.network.manager.handler.message.PingMessageHandler;
import io.nuls.network.manager.handler.message.PongMessageHandler;
import io.nuls.network.manager.handler.message.TimeMessageHandler;
import io.nuls.network.manager.handler.message.VerackMessageHandler;
import io.nuls.network.manager.handler.message.VersionMessageHandler;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.BestBlockInfo;
import io.nuls.network.model.dto.IpAddress;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.model.message.AddrMessage;
import io.nuls.network.model.message.GetAddrMessage;
import io.nuls.network.model.message.GetTimeMessage;
import io.nuls.network.model.message.PeerInfoMessage;
import io.nuls.network.model.message.PingMessage;
import io.nuls.network.model.message.PongMessage;
import io.nuls.network.model.message.TimeMessage;
import io.nuls.network.model.message.VerackMessage;
import io.nuls.network.model.message.VersionMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.AddrMessageBody;
import io.nuls.network.model.message.body.GetAddrMessageBody;
import io.nuls.network.model.message.body.GetTimeMessageBody;
import io.nuls.network.model.message.body.PeerInfoMessageBody;
import io.nuls.network.model.message.body.PingPongMessageBody;
import io.nuls.network.model.message.body.TimeMessageBody;
import io.nuls.network.model.message.body.VerackMessageBody;
import io.nuls.network.model.message.body.VersionMessageBody;
import io.nuls.network.utils.LoggerUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class MessageFactory {
    private static MessageFactory instance = new MessageFactory();
    private static final Map<String, Class<? extends BaseMessage>> MESSAGE_MAP = new HashMap<String, Class<? extends BaseMessage>>();
    NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
    private NodeGroupManager nodeGroupManager = NodeGroupManager.getInstance();

    private MessageFactory() {
    }

    public static MessageFactory getInstance() {
        return instance;
    }

    void init() {
        MessageFactory.putMessage(VersionMessage.class, VersionMessageHandler.getInstance());
        MessageFactory.putMessage(VerackMessage.class, VerackMessageHandler.getInstance());
        MessageFactory.putMessage(GetAddrMessage.class, GetAddrMessageHandler.getInstance());
        MessageFactory.putMessage(AddrMessage.class, AddrMessageHandler.getInstance());
        MessageFactory.putMessage(GetTimeMessage.class, GetTimeMessageHandler.getInstance());
        MessageFactory.putMessage(TimeMessage.class, TimeMessageHandler.getInstance());
        MessageFactory.putMessage(PeerInfoMessage.class, PeerInfoMessageHandler.getInstance());
        MessageFactory.putMessage(PingMessage.class, PingMessageHandler.getInstance());
        MessageFactory.putMessage(PongMessage.class, PongMessageHandler.getInstance());
    }

    static void putMessage(Class<? extends BaseMessage> msgClass, BaseMeesageHandlerInf handlerInf) {
        try {
            BaseMessage message = msgClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            MESSAGE_MAP.put(message.getHeader().getCommandStr(), msgClass);
            MessageHandlerFactory.addHandler(message.getHeader().getCommandStr(), handlerInf);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    static Class<? extends BaseMessage> getMessage(String command) {
        return MESSAGE_MAP.get(command);
    }

    public VersionMessage buildVersionMessage(Node node, long magicNumber) {
        NodeGroup nodeGroup = this.nodeGroupManager.getNodeGroupByMagic(magicNumber);
        VersionMessageBody versionMessageBody = new VersionMessageBody();
        try {
            InetAddress inetAddrYou = InetAddress.getByName(node.getIp());
            IpAddress addrYou = new IpAddress(inetAddrYou, node.getRemotePort());
            versionMessageBody.setAddrYou(addrYou);
            int localPort = 0;
            localPort = node.isCrossConnect() ? this.networkConfig.getCrossPort() : this.networkConfig.getPort();
            IpAddress addrMe = new IpAddress(this.networkConfig.getExternalIp(), localPort);
            versionMessageBody.setAddrMe(addrMe);
            return new VersionMessage(nodeGroup.getMagicNumber(), "version", versionMessageBody);
        }
        catch (UnknownHostException e) {
            LoggerUtil.logger(nodeGroup.getChainId()).error(e.getMessage(), (Exception)e);
            return null;
        }
    }

    public VerackMessage buildVerackMessage(Node node, long magicNumber, int ackCode) {
        VerackMessageBody verackMessageBody = new VerackMessageBody(ackCode);
        return new VerackMessage(magicNumber, "verAck", verackMessageBody);
    }

    GetAddrMessage buildGetAddrMessage(NodeGroup nodeGroup, boolean isCrossAddress) {
        GetAddrMessageBody messageBody = new GetAddrMessageBody();
        messageBody.setChainId(nodeGroup.getChainId());
        messageBody.setIsCrossAddress(isCrossAddress ? (byte)1 : 0);
        return new GetAddrMessage(nodeGroup.getMagicNumber(), "getAddr", messageBody);
    }

    GetAddrMessage buildGetAddrMessage(int chainId, long magicNumber, boolean isCrossAddress) {
        GetAddrMessageBody messageBody = new GetAddrMessageBody();
        messageBody.setChainId(chainId);
        messageBody.setIsCrossAddress(isCrossAddress ? (byte)1 : 0);
        return new GetAddrMessage(magicNumber, "getAddr", messageBody);
    }

    public AddrMessage buildAddrMessage(List<IpAddressShare> ipAddressList, long magicNumber, int chainId, byte isCrossAddress) {
        AddrMessageBody addrMessageBody = new AddrMessageBody();
        addrMessageBody.setIpAddressList(ipAddressList);
        addrMessageBody.setChainId(chainId);
        addrMessageBody.setIsCross(isCrossAddress);
        return new AddrMessage(magicNumber, "addr", addrMessageBody);
    }

    public GetTimeMessage buildTimeRequestMessage(long magicNumber, long messageId) {
        GetTimeMessageBody messageBody = new GetTimeMessageBody();
        messageBody.setMessageId(messageId);
        return new GetTimeMessage(magicNumber, "getTime", messageBody);
    }

    public TimeMessage buildTimeResponseMessage(long magicNumber, long messageId) {
        TimeMessageBody messageBody = new TimeMessageBody();
        messageBody.setMessageId(messageId);
        messageBody.setTime(System.currentTimeMillis());
        return new TimeMessage(magicNumber, "responseTime", messageBody);
    }

    public PingMessage buildPingMessage(long magicNumber) {
        PingPongMessageBody messageBody = new PingPongMessageBody();
        Random rand = new Random();
        messageBody.setRandomCode(rand.nextInt(10000000));
        return new PingMessage(magicNumber, "ping", messageBody);
    }

    public PongMessage buildPongMessage(PingMessage pingMessage) {
        PingPongMessageBody messageBody = new PingPongMessageBody();
        messageBody.setRandomCode(((PingPongMessageBody)((Object)pingMessage.getMsgBody())).getRandomCode());
        return new PongMessage(pingMessage.getHeader().getMagicNumber(), "pong", messageBody);
    }

    public PeerInfoMessage buildPeerInfoMessage(long magicNumber, BestBlockInfo bestBlockInfo) {
        PeerInfoMessageBody messageBody = new PeerInfoMessageBody();
        messageBody.setBlockHash(bestBlockInfo.getHash());
        messageBody.setBlockHeight(bestBlockInfo.getBlockHeight());
        return new PeerInfoMessage(magicNumber, "peerInfos", messageBody);
    }
}

