/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.model.message.AddrMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.AddrMessageBody;
import io.nuls.network.model.message.body.GetAddrMessageBody;
import io.nuls.network.utils.LoggerUtil;
import java.util.List;

public class GetAddrMessageHandler
extends BaseMessageHandler {
    private static GetAddrMessageHandler instance = new GetAddrMessageHandler();

    private GetAddrMessageHandler() {
    }

    public static GetAddrMessageHandler getInstance() {
        return instance;
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        int chainId = node.getNodeGroup().getChainId();
        LoggerUtil.logger(chainId).info("GetAddrMessageHandler Recieve:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        GetAddrMessageBody getAddrMessageBody = (GetAddrMessageBody)((Object)message.getMsgBody());
        List<IpAddressShare> ipAddresses = NodeGroupManager.getInstance().getAvailableShareNodes(node, getAddrMessageBody.getChainId(), getAddrMessageBody.getIsCrossAddress() == 1);
        AddrMessage addressMessage = MessageFactory.getInstance().buildAddrMessage(ipAddresses, message.getHeader().getMagicNumber(), getAddrMessageBody.getChainId(), getAddrMessageBody.getIsCrossAddress());
        if (0 == ((AddrMessageBody)((Object)addressMessage.getMsgBody())).getIpAddressList().size()) {
            LoggerUtil.logger(chainId).info("No Address");
        } else {
            LoggerUtil.logger(chainId).info("send addressMessage node = {}", new Object[]{node.getId()});
            MessageManager.getInstance().sendHandlerMsg(addressMessage, node, true);
        }
        return NetworkEventResult.getResultSuccess();
    }

    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("GetAddrMessageHandler Send:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        return super.send(message, node, asyn);
    }
}

