/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.message.GetTimeMessage;
import io.nuls.network.model.message.TimeMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.GetTimeMessageBody;
import io.nuls.network.utils.LoggerUtil;

public class GetTimeMessageHandler
extends BaseMessageHandler {
    private static GetTimeMessageHandler instance = new GetTimeMessageHandler();

    private GetTimeMessageHandler() {
    }

    public static GetTimeMessageHandler getInstance() {
        return instance;
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("GetTimeMessageHandler Recieve:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        GetTimeMessage getTimeMessage = (GetTimeMessage)message;
        TimeMessage timeMessage = MessageFactory.getInstance().buildTimeResponseMessage(message.getHeader().getMagicNumber(), ((GetTimeMessageBody)((Object)getTimeMessage.getMsgBody())).getMessageId());
        MessageManager.getInstance().sendHandlerMsg(timeMessage, node, true);
        return NetworkEventResult.getResultSuccess();
    }

    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("GetTimeMessageHandler Send:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        return super.send(message, node, asyn);
    }
}

