/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.message.PeerInfoMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.PeerInfoMessageBody;
import io.nuls.network.utils.LoggerUtil;

public class PeerInfoMessageHandler
extends BaseMessageHandler {
    private static PeerInfoMessageHandler instance = new PeerInfoMessageHandler();

    private PeerInfoMessageHandler() {
    }

    public static PeerInfoMessageHandler getInstance() {
        return instance;
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByMagic(message.getHeader().getMagicNumber());
        PeerInfoMessage peerInfoMessage = (PeerInfoMessage)message;
        LoggerUtil.logger(nodeGroup.getChainId()).debug("PeerInfoMessageHandler Recieve:{},CMD={},height={} ", new Object[]{node.getId(), message.getHeader().getCommandStr(), ((PeerInfoMessageBody)((Object)peerInfoMessage.getMsgBody())).getBlockHeight()});
        node.setBlockHash(((PeerInfoMessageBody)((Object)peerInfoMessage.getMsgBody())).getBlockHash());
        node.setBlockHeight(((PeerInfoMessageBody)((Object)peerInfoMessage.getMsgBody())).getBlockHeight());
        return NetworkEventResult.getResultSuccess();
    }

    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("PeerInfoMessageHandler Send:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        return super.send(message, node, asyn);
    }
}

