/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.manager.handler.message;

import io.nuls.network.manager.MessageFactory;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.TimeManager;
import io.nuls.network.manager.handler.base.BaseMessageHandler;
import io.nuls.network.model.NetworkEventResult;
import io.nuls.network.model.Node;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.IpAddressShare;
import io.nuls.network.model.message.AddrMessage;
import io.nuls.network.model.message.VerackMessage;
import io.nuls.network.model.message.base.BaseMessage;
import io.nuls.network.model.message.body.AddrMessageBody;
import io.nuls.network.model.message.body.VerackMessageBody;
import io.nuls.network.utils.LoggerUtil;
import java.util.List;

public class VerackMessageHandler
extends BaseMessageHandler {
    private static VerackMessageHandler instance = new VerackMessageHandler();

    private VerackMessageHandler() {
    }

    public static VerackMessageHandler getInstance() {
        return instance;
    }

    @Override
    public NetworkEventResult recieve(BaseMessage message, Node node) {
        long magicNumber = message.getHeader().getMagicNumber();
        NodeGroup nodeGroup = NodeGroupManager.getInstance().getNodeGroupByMagic(magicNumber);
        VerackMessage verackMessage = (VerackMessage)message;
        LoggerUtil.logger(nodeGroup.getChainId()).debug("VerackMessageHandler Recieve:{}-{}", new Object[]{node.getIp() + ":" + node.getRemotePort(), message.getHeader().getCommandStr()});
        if (VerackMessageBody.VER_CONNECT_MAX == ((VerackMessageBody)((Object)verackMessage.getMsgBody())).getAckCode()) {
            LoggerUtil.logger(nodeGroup.getChainId()).info("recieve versionAck peer max!peer = {}s", new Object[]{node.getId()});
            node.getChannel().close();
        } else {
            node.setConnectStatus(5);
            node.setFailCount(0);
            node.setConnectTime(TimeManager.currentTimeMillis());
            if (node.isCrossConnect()) {
                node.getNodeGroup().getCrossNodeContainer().setLatestHandshakeSuccTime(TimeManager.currentTimeMillis());
            } else {
                node.getNodeGroup().getLocalNetNodeContainer().setLatestHandshakeSuccTime(TimeManager.currentTimeMillis());
            }
            List<NodeGroup> nodeGroupList = NodeGroupManager.getInstance().getNodeGroups();
            nodeGroupList.forEach(nodeGroupShareAddrs -> {
                List<IpAddressShare> ipAddresses = NodeGroupManager.getInstance().getAvailableShareNodes(node, nodeGroupShareAddrs.getChainId(), true);
                AddrMessage addressMessage = MessageFactory.getInstance().buildAddrMessage(ipAddresses, message.getHeader().getMagicNumber(), nodeGroupShareAddrs.getChainId(), (byte)1);
                if (((AddrMessageBody)((Object)((Object)addressMessage.getMsgBody()))).getIpAddressList().size() > 0) {
                    LoggerUtil.logger(nodeGroupShareAddrs.getChainId()).info("send addressMessage node = {}", new Object[]{node.getId()});
                    MessageManager.getInstance().sendHandlerMsg(addressMessage, node, true);
                }
            });
        }
        return NetworkEventResult.getResultSuccess();
    }

    @Override
    public NetworkEventResult send(BaseMessage message, Node node, boolean asyn) {
        LoggerUtil.logger(node.getNodeGroup().getChainId()).debug("VerackMessageHandler send:" + (node.isServer() ? "Server" : "Client") + ":" + node.getIp() + ":" + node.getRemotePort() + "==CMD=" + message.getHeader().getCommandStr());
        return super.send(message, node, asyn);
    }
}

