/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model;

import io.netty.channel.Channel;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.NodeGroup;
import io.nuls.network.model.dto.Dto;
import io.nuls.network.model.dto.PeerCacheMessage;
import io.nuls.network.model.po.BasePo;
import io.nuls.network.model.po.NodePo;
import io.nuls.network.netty.listener.EventListener;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class Node
implements Dto {
    public static final int IN = 1;
    public static final int OUT = 2;
    private long magicNumber;
    private String id;
    private String ip;
    private int remotePort = 0;
    private int remoteCrossPort = 0;
    private Long lastFailTime = 0L;
    private Integer failCount = 0;
    private Channel channel;
    private String externalIp;
    private boolean isCrossConnect;
    private int type;
    private long connectTime = 0L;
    private long version = 0L;
    private long blockHeight = 0L;
    private String blockHash = "";
    private int status;
    private int connectStatus;
    private boolean isSeedNode = false;
    private boolean hadShare = false;
    private Long lastProbeTime = 0L;
    private EventListener registerListener;
    private EventListener connectedListener;
    private EventListener disconnectListener;
    private BlockingDeque<PeerCacheMessage> cacheSendMsgQueue = new LinkedBlockingDeque<PeerCacheMessage>(110);

    public Node(long magicNumber, String ip, int remotePort, int remoteCrossPort, int type, boolean isCrossConnect) {
        this(ip + ":" + remotePort, magicNumber, ip, remotePort, remoteCrossPort, type, isCrossConnect);
    }

    public Node(String id, long magicNumber, String ip, int remotePort, int remoteCrossPort, int type, boolean isCrossConnect) {
        this.ip = ip;
        this.magicNumber = magicNumber;
        this.remotePort = remotePort;
        this.remoteCrossPort = remoteCrossPort;
        this.type = type;
        this.id = id;
        this.isCrossConnect = isCrossConnect;
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public void close() {
        this.channel.close();
        this.channel = null;
    }

    public EventListener getRegisterListener() {
        return this.registerListener;
    }

    public void setRegisterListener(EventListener registerListener) {
        this.registerListener = registerListener;
    }

    public EventListener getConnectedListener() {
        return this.connectedListener;
    }

    public void setConnectedListener(EventListener connectedListener) {
        this.connectedListener = connectedListener;
    }

    public EventListener getDisconnectListener() {
        return this.disconnectListener;
    }

    public void setDisconnectListener(EventListener disconnectListener) {
        this.disconnectListener = disconnectListener;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getFailCount() {
        if (this.failCount == null) {
            this.failCount = 0;
        }
        return this.failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public Long getLastFailTime() {
        if (this.lastFailTime == null) {
            this.lastFailTime = 0L;
        }
        return this.lastFailTime;
    }

    public void setLastFailTime(Long lastFailTime) {
        this.lastFailTime = lastFailTime;
    }

    public String getId() {
        return this.ip + ":" + this.remotePort;
    }

    public String getPoId() {
        this.id = this.ip + ":" + this.remotePort;
        return this.id;
    }

    public boolean isSeedNode() {
        return this.isSeedNode;
    }

    public void setSeedNode(boolean seedNode) {
        this.isSeedNode = seedNode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemoteCrossPort() {
        return this.remoteCrossPort;
    }

    public void setRemoteCrossPort(int remoteCrossPort) {
        this.remoteCrossPort = remoteCrossPort;
    }

    public boolean isCrossConnect() {
        return this.isCrossConnect;
    }

    public void setCrossConnect(boolean crossConnect) {
        this.isCrossConnect = crossConnect;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getConnectStatus() {
        return this.connectStatus;
    }

    public void setConnectStatus(int connectStatus) {
        this.connectStatus = connectStatus;
    }

    public Long getLastProbeTime() {
        return this.lastProbeTime;
    }

    public void setLastProbeTime(Long lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
    }

    public String getExternalIp() {
        return this.externalIp;
    }

    public void setExternalIp(String externalIp) {
        this.externalIp = externalIp;
    }

    public boolean isServer() {
        return 1 == this.type;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public NodeGroup getNodeGroup() {
        return NodeGroupManager.getInstance().getNodeGroupByMagic(this.magicNumber);
    }

    public void setVersionProtocolInfos(long version, long blockHeight, String blockHash) {
        this.version = version;
        this.blockHash = blockHash;
        this.blockHeight = blockHeight;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public boolean isHadShare() {
        return this.hadShare;
    }

    public void setHadShare(boolean hadShare) {
        this.hadShare = hadShare;
    }

    public BlockingDeque<PeerCacheMessage> getCacheSendMsgQueue() {
        return this.cacheSendMsgQueue;
    }

    public void setCacheSendMsgQueue(BlockingDeque<PeerCacheMessage> cacheSendMsgQueue) {
        this.cacheSendMsgQueue = cacheSendMsgQueue;
    }

    @Override
    public BasePo parseToPo() {
        return new NodePo(this.magicNumber, this.id, this.ip, this.remotePort, this.remoteCrossPort, this.isCrossConnect, this.status, this.failCount);
    }
}

