/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.model.Node;
import io.nuls.network.model.dto.Dto;
import io.nuls.network.model.dto.RpcCacheMessage;
import io.nuls.network.model.po.BasePo;
import io.nuls.network.model.po.GroupNodesPo;
import io.nuls.network.model.po.GroupPo;
import io.nuls.network.model.po.NodePo;
import io.nuls.network.model.po.NodesContainerPo;
import io.nuls.network.netty.container.NodesContainer;
import io.nuls.network.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NodeGroup
implements Dto {
    NulsCoresConfig networkConfig = (NulsCoresConfig)SpringLiteContext.getBean(NulsCoresConfig.class);
    private BlockingDeque<RpcCacheMessage> cacheMsgQueue = new LinkedBlockingDeque<RpcCacheMessage>(110);
    private long magicNumber;
    private int chainId;
    private int maxOut;
    private int maxIn;
    private int maxCrossOut = 0;
    private int maxCrossIn = 0;
    private int minAvailableCount;
    private boolean isCrossActive = false;
    private NodesContainer localNetNodeContainer = new NodesContainer();
    private NodesContainer crossNodeContainer = new NodesContainer();
    private Map<String, Node> localShareToCrossUncheckNodes = new ConcurrentHashMap<String, Node>();
    private Map<String, Node> localShareToCrossCanConnectNodes = new ConcurrentHashMap<String, Node>();
    private boolean hadBlockHeigh = false;
    private Lock locker = new ReentrantLock();
    public static final int WAIT1 = 1;
    public static final int WAIT2 = 2;
    public static final int OK = 3;
    private static final int DESTROY = -1;
    private static final int RECONNECT = -2;
    public static Map<String, String> statusMap = new HashMap<String, String>();

    public String getLocalStatus() {
        return statusMap.get(String.valueOf(this.localNetNodeContainer.getStatus()));
    }

    public String getCrossStatus() {
        return statusMap.get(String.valueOf(this.crossNodeContainer.getStatus()));
    }

    public NodeGroup() {
        this.magicNumber = this.networkConfig.getPacketMagic();
        this.chainId = this.networkConfig.getChainId();
        this.maxIn = this.networkConfig.getMaxInCount();
        this.maxOut = this.networkConfig.getMaxOutCount();
        this.minAvailableCount = 0;
    }

    public NodeGroup(long magicNumber, int chainId, int maxIn, int maxOut, int minAvailableCount) {
        this.magicNumber = magicNumber;
        this.chainId = chainId;
        this.maxIn = maxIn;
        this.maxOut = maxOut;
        this.minAvailableCount = minAvailableCount;
        if (this.networkConfig.isMoonNode()) {
            this.isCrossActive = true;
            this.maxCrossIn = maxIn;
            this.maxCrossOut = maxOut;
        }
    }

    public NodesContainer getLocalNetNodeContainer() {
        return this.localNetNodeContainer;
    }

    public void setLocalNetNodeContainer(NodesContainer localNetNodeContainer) {
        this.localNetNodeContainer = localNetNodeContainer;
    }

    public NodesContainer getCrossNodeContainer() {
        return this.crossNodeContainer;
    }

    public void setCrossNodeContainer(NodesContainer crossNodeContainer) {
        this.crossNodeContainer = crossNodeContainer;
    }

    public Map<String, Node> getLocalShareToCrossUncheckNodes() {
        return this.localShareToCrossUncheckNodes;
    }

    public void setLocalShareToCrossUncheckNodes(Map<String, Node> localShareToCrossUncheckNodes) {
        this.localShareToCrossUncheckNodes = localShareToCrossUncheckNodes;
    }

    public Map<String, Node> getLocalShareToCrossCanConnectNodes() {
        return this.localShareToCrossCanConnectNodes;
    }

    public void setLocalShareToCrossCanConnectNodes(Map<String, Node> localShareToCrossCanConnectNodes) {
        this.localShareToCrossCanConnectNodes = localShareToCrossCanConnectNodes;
    }

    public boolean isCrossActive() {
        return this.isCrossActive;
    }

    public void setCrossActive(boolean crossActive) {
        this.isCrossActive = crossActive;
    }

    public boolean isHadBlockHeigh() {
        return this.hadBlockHeigh;
    }

    public void setHadBlockHeigh(boolean hadBlockHeigh) {
        this.hadBlockHeigh = hadBlockHeigh;
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public int getMaxOut() {
        return this.maxOut;
    }

    public void setMaxOut(int maxOut) {
        this.maxOut = maxOut;
    }

    public int getMaxIn() {
        return this.maxIn;
    }

    public void setMaxIn(int maxIn) {
        this.maxIn = maxIn;
    }

    public int getMinAvailableCount() {
        return this.minAvailableCount;
    }

    public void setMinAvailableCount(int minAvailableCount) {
        this.minAvailableCount = minAvailableCount;
    }

    public int getMaxCrossOut() {
        return this.maxCrossOut;
    }

    public void setMaxCrossOut(int maxCrossOut) {
        this.maxCrossOut = maxCrossOut;
    }

    public int getMaxCrossIn() {
        return this.maxCrossIn;
    }

    public void setMaxCrossIn(int maxCrossIn) {
        this.maxCrossIn = maxCrossIn;
    }

    public boolean isMoonCrossGroup() {
        return this.networkConfig.isMoonNode() && this.networkConfig.getChainId() != this.chainId;
    }

    public BlockingDeque<RpcCacheMessage> getCacheMsgQueue() {
        return this.cacheMsgQueue;
    }

    public void setCacheMsgQueue(BlockingDeque<RpcCacheMessage> cacheMsgQueue) {
        this.cacheMsgQueue = cacheMsgQueue;
    }

    public void stopConnectedSeeds(boolean isCross) {
        try {
            List<Node> nodes = null;
            int canConnectNodesNum = 0;
            if (isCross) {
                nodes = this.crossNodeContainer.getConnectedSeedNodes();
                canConnectNodesNum = this.crossNodeContainer.getCanConnectNodes().size();
            } else {
                nodes = this.localNetNodeContainer.getConnectedSeedNodes();
                canConnectNodesNum = this.localNetNodeContainer.getCanConnectNodes().size();
            }
            if (nodes.size() > 1 && canConnectNodesNum > 0) {
                Collections.shuffle(nodes);
                while (canConnectNodesNum < nodes.size()) {
                    nodes.remove(0);
                }
            } else {
                return;
            }
            for (Node node : nodes) {
                node.close();
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    public boolean isMoonGroup() {
        return this.networkConfig.isMoonNode() && this.networkConfig.getChainId() == this.chainId;
    }

    public boolean isMoonNode() {
        return this.networkConfig.isMoonNode();
    }

    public int getSameIpMaxCount(boolean isCross) {
        int sameIpMaxCount = 0;
        sameIpMaxCount = isCross ? this.networkConfig.getCrossMaxInSameIp() : this.networkConfig.getMaxInSameIp();
        return sameIpMaxCount;
    }

    private void loadNodes(Map<String, Node> nodeMap, List<NodePo> nodePoList) {
        if (nodePoList != null) {
            for (NodePo nodePo : nodePoList) {
                Node node = (Node)nodePo.parseDto();
                node.setMagicNumber(this.magicNumber);
                if (null != nodeMap.get(node.getId())) continue;
                nodeMap.put(node.getId(), node);
            }
        }
    }

    public void addCrossCheckNodes(String ip, int port, int crossPort) {
        Node shareToCrossCheckNode = new Node(this.magicNumber, ip, crossPort, crossPort, 2, true);
        if (null == this.localShareToCrossUncheckNodes.get(shareToCrossCheckNode.getId()) && null == this.localShareToCrossCanConnectNodes.get(shareToCrossCheckNode.getId())) {
            this.localShareToCrossUncheckNodes.put(shareToCrossCheckNode.getId(), shareToCrossCheckNode);
        }
    }

    private void loadNodes(NodesContainer nodesContainer, NodesContainerPo nodesContainerPo) {
        this.loadNodes(nodesContainer.getDisconnectNodes(), nodesContainerPo.getDisConnectNodes());
        this.loadNodes(nodesContainer.getUncheckNodes(), nodesContainerPo.getUncheckNodes());
        this.loadNodes(nodesContainer.getFailNodes(), nodesContainerPo.getFailNodes());
        this.loadNodes(nodesContainer.getCanConnectNodes(), nodesContainerPo.getCanConnectNodes());
    }

    public void loadNodes(GroupNodesPo groupNodesPo) {
        this.loadNodes(this.localNetNodeContainer, groupNodesPo.getSelfNodeContainer());
        this.loadNodes(this.crossNodeContainer, groupNodesPo.getCrossNodeContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNeedCheckNode(String ip, int port, int crossPort, boolean isCross) {
        this.locker.lock();
        try {
            if (isCross) {
                Node newNode = new Node(this.magicNumber, ip, crossPort, crossPort, 2, isCross);
                boolean bl = this.crossNodeContainer.addNeedCheckNode(newNode);
                return bl;
            }
            Node newNode = new Node(this.magicNumber, ip, port, crossPort, 2, isCross);
            boolean localAdd = this.localNetNodeContainer.addNeedCheckNode(newNode);
            if (crossPort > 0 && localAdd) {
                this.addCrossCheckNodes(ip, crossPort, crossPort);
            }
            boolean bl = localAdd;
            return bl;
        }
        finally {
            this.locker.unlock();
        }
    }

    public Collection<Node> getCanConnectNodes(boolean isCross) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Collection<Node> allNodes = null;
        Map<String, Node> connectedNodes = null;
        if (isCross) {
            allNodes = this.crossNodeContainer.getCanConnectNodes().values();
            connectedNodes = this.crossNodeContainer.getConnectedNodes();
        } else {
            allNodes = this.localNetNodeContainer.getCanConnectNodes().values();
            connectedNodes = this.localNetNodeContainer.getConnectedNodes();
        }
        for (Node node : allNodes) {
            if (node.getStatus() != 2 || null != connectedNodes.get(node.getId())) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    public Collection<Node> getConnectedNodes(boolean isCross) {
        if (isCross) {
            return this.crossNodeContainer.getConnectedNodes().values();
        }
        return this.localNetNodeContainer.getConnectedNodes().values();
    }

    public List<Node> getAvailableNodes(boolean isCross) {
        if (isCross) {
            return this.crossNodeContainer.getAvailableNodes();
        }
        return this.localNetNodeContainer.getAvailableNodes();
    }

    public Node getAvailableNode(String nodeId) {
        Node node = this.localNetNodeContainer.getConnectedNodes().get(nodeId);
        if (null == node) {
            node = this.crossNodeContainer.getConnectedNodes().get(nodeId);
        }
        if (null != node && 5 == node.getConnectStatus()) {
            return node;
        }
        return null;
    }

    public Node getConnectedNode(String nodeId) {
        Node node = this.localNetNodeContainer.getConnectedNodes().get(nodeId);
        if (null == node) {
            node = this.crossNodeContainer.getConnectedNodes().get(nodeId);
        }
        return node;
    }

    public void destroy() {
        this.localNetNodeContainer.setStatus(-1);
        this.crossNodeContainer.setStatus(-1);
        NodeGroupManager.getInstance().removeNodeGroup(this.chainId);
        Collection<Node> nodes = this.localNetNodeContainer.getConnectedNodes().values();
        for (Node node : nodes) {
            node.close();
        }
        Collection<Node> crossNodes = this.crossNodeContainer.getConnectedNodes().values();
        for (Node node : crossNodes) {
            node.close();
        }
        this.crossNodeContainer.clear();
        this.localNetNodeContainer.clear();
    }

    public void reconnect(boolean isCross) {
        if (isCross) {
            this.crossNodeContainer.setStatus(-2);
            Collection<Node> crossNodes = this.crossNodeContainer.getConnectedNodes().values();
            for (Node node : crossNodes) {
                LoggerUtil.logger(this.chainId).info("cross chainId={} node={} reconnect", new Object[]{this.chainId, node.getId()});
                node.close();
            }
            this.crossNodeContainer.setStatus(2);
        } else {
            this.localNetNodeContainer.setStatus(-2);
            Collection<Node> nodes = this.localNetNodeContainer.getConnectedNodes().values();
            for (Node node : nodes) {
                LoggerUtil.logger(this.chainId).info("local chainId={} node={} reconnect", new Object[]{this.chainId, node.getId()});
                node.close();
            }
            this.localNetNodeContainer.setStatus(2);
        }
    }

    public boolean isActive(boolean isCross) {
        int activeConnectNum = 0;
        if (isCross) {
            if (-1 == this.crossNodeContainer.getStatus() || -2 == this.crossNodeContainer.getStatus()) {
                return false;
            }
            activeConnectNum = this.crossNodeContainer.getConnectedNodes().size();
            if (this.networkConfig.isMoonNode() && activeConnectNum < this.minAvailableCount) {
                return false;
            }
        } else {
            if (-1 == this.localNetNodeContainer.getStatus() || -2 == this.localNetNodeContainer.getStatus()) {
                return false;
            }
            activeConnectNum = this.localNetNodeContainer.getConnectedNodes().size();
        }
        return activeConnectNum > 0;
    }

    public void addUnCheckNode(Node node) {
        if (node.isCrossConnect()) {
            this.crossNodeContainer.getUncheckNodes().put(node.getId(), node);
        } else {
            this.localNetNodeContainer.getUncheckNodes().put(node.getId(), node);
        }
    }

    @Override
    public BasePo parseToPo() {
        GroupPo po = new GroupPo();
        po.setChainId(this.chainId);
        po.setCrossActive(this.isCrossActive);
        po.setMagicNumber(this.magicNumber);
        po.setMaxCrossIn(this.maxCrossIn);
        po.setMaxCrossOut(this.maxCrossOut);
        po.setMaxIn(this.maxIn);
        po.setMaxOut(this.maxOut);
        po.setMinAvailableCount(this.minAvailableCount);
        return po;
    }

    static {
        statusMap.put(String.valueOf(1), "netInit(initialization)");
        statusMap.put(String.valueOf(2), "waitConnected(To be networked)");
        statusMap.put(String.valueOf(3), "running(Running)");
        statusMap.put(String.valueOf(-1), "destroy(Cancelling)");
        statusMap.put(String.valueOf(-2), "reconnect(Reconnection)");
    }
}

