/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.dto;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpAddress
extends BaseNulsData {
    private static final int IPSIZE = 16;
    private InetAddress ip;
    private int port;

    public IpAddress() {
    }

    public IpAddress(String ipStr, int port) {
        try {
            this.ip = InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            Log.error((Throwable)e);
        }
        this.port = port;
    }

    public IpAddress(InetAddress ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public void setIpStr(String ipStr) {
        try {
            this.ip = InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int size() {
        int s = 0;
        s += 16;
        return s += SerializeUtils.sizeOfUint16();
    }

    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        byte[] ipBytes = this.ip.getAddress();
        if (ipBytes.length == SerializeUtils.sizeOfInt32()) {
            byte[] v6addr = new byte[16];
            System.arraycopy(ipBytes, 0, v6addr, 12, 4);
            v6addr[10] = -1;
            v6addr[11] = -1;
            ipBytes = v6addr;
        }
        stream.write(ipBytes);
        stream.writeUint16(this.port);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        try {
            byte[] ipAddrBytes = byteBuffer.readBytes(16);
            this.ip = InetAddress.getByAddress(ipAddrBytes);
            this.port = byteBuffer.readUint16();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
    }
}

