/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.dto;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpAddressShare
extends BaseNulsData {
    private static final int IPSIZE = 16;
    private InetAddress ip;
    private int port = 0;
    private int crossPort = 0;

    public IpAddressShare() {
    }

    public IpAddressShare(String ipStr, int port, int crossPort) {
        try {
            this.ip = InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            Log.error((Throwable)e);
        }
        this.port = port;
        this.crossPort = crossPort;
    }

    public void setIpStr(String ipStr) {
        try {
            this.ip = InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            Log.error((Throwable)e);
        }
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public String getIpStr() {
        return this.ip.getHostAddress();
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getCrossPort() {
        return this.crossPort;
    }

    public void setCrossPort(int crossPort) {
        this.crossPort = crossPort;
    }

    public int size() {
        int s = 0;
        s += 16;
        s += SerializeUtils.sizeOfUint16();
        return s += SerializeUtils.sizeOfUint16();
    }

    public void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        byte[] ipBytes = this.ip.getAddress();
        if (ipBytes.length == SerializeUtils.sizeOfInt32()) {
            byte[] v6addr = new byte[16];
            System.arraycopy(ipBytes, 0, v6addr, 12, 4);
            v6addr[10] = -1;
            v6addr[11] = -1;
            ipBytes = v6addr;
        }
        stream.write(ipBytes);
        stream.writeUint16(this.port);
        stream.writeUint16(this.crossPort);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        try {
            byte[] ipAddrBytes = byteBuffer.readBytes(16);
            this.ip = InetAddress.getByAddress(ipAddrBytes);
            this.port = byteBuffer.readUint16();
            this.crossPort = byteBuffer.readUint16();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

