/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.message.base;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.contract.util.Log;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class MessageHeader
extends BaseNulsData {
    private long magicNumber;
    private long payloadLength;
    private byte[] command = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private long checksum;
    private transient String commandStr = null;

    public MessageHeader() {
    }

    public MessageHeader(String command, long magicNumber) {
        byte[] commandBytes = command.getBytes();
        System.arraycopy(commandBytes, 0, this.command, 0, commandBytes.length);
        this.magicNumber = magicNumber;
    }

    public MessageHeader(String command, long magicNumber, long checksum, long payloadLength) {
        byte[] commandBytes = command.getBytes();
        System.arraycopy(commandBytes, 0, this.command, 0, commandBytes.length);
        this.magicNumber = magicNumber;
        this.payloadLength = payloadLength;
        this.checksum = checksum;
    }

    public MessageHeader(String command) {
        byte[] commandBytes = command.getBytes();
        System.arraycopy(commandBytes, 0, this.command, 0, commandBytes.length);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.magicNumber);
        stream.writeUint32(this.payloadLength);
        stream.write(this.command);
        stream.writeUint32(this.checksum);
    }

    public String getCommandStr() {
        if (null != this.commandStr) {
            return this.commandStr;
        }
        int effectiveCmdLen = 0;
        for (int i = 0; i < 12 && this.command[i] != -1; ++i) {
            ++effectiveCmdLen;
        }
        byte[] effectiveCmd = new byte[effectiveCmdLen];
        System.arraycopy(this.command, 0, effectiveCmd, 0, effectiveCmdLen);
        this.commandStr = new String(effectiveCmd);
        return this.commandStr;
    }

    public void parse(NulsByteBuffer buffer) throws NulsException {
        try {
            this.magicNumber = buffer.readUint32();
            this.payloadLength = buffer.readUint32();
            this.command = buffer.readBytes(12);
            this.checksum = buffer.readUint32();
        }
        catch (Exception e) {
            Log.error("Message error: {}", HexUtil.encode((byte[])buffer.getPayload()));
            throw new NulsException((Throwable)e);
        }
    }

    public int size() {
        int s = 0;
        s += SerializeUtils.sizeOfUint32();
        s += SerializeUtils.sizeOfUint32();
        s += this.command.length;
        return s += SerializeUtils.sizeOfUint32();
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(long payloadLength) {
        this.payloadLength = payloadLength;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public void setCommand(byte[] command) {
        this.command = command;
    }
}

