/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.model.message.body;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.network.model.dto.IpAddressShare;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AddrMessageBody
extends BaseNulsData {
    private int chainId = 0;
    private byte isCross = 0;
    private List<IpAddressShare> ipAddressList = new ArrayList<IpAddressShare>();

    public void addAddr(IpAddressShare addr) {
        this.ipAddressList.add(addr);
    }

    public int size() {
        int s = 0;
        s += SerializeUtils.sizeOfUint16();
        ++s;
        s = this.ipAddressList.size() > 0 ? (s += this.ipAddressList.size() * new IpAddressShare().size()) : 4;
        return s;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeByte(this.isCross);
        if (0 == this.ipAddressList.size()) {
            stream.write(ToolsConstant.PLACE_HOLDER);
        } else {
            for (IpAddressShare address : this.ipAddressList) {
                address.serializeToStream(stream);
            }
        }
    }

    public void parse(NulsByteBuffer buffer) throws NulsException {
        try {
            this.chainId = buffer.readUint16();
            this.isCross = buffer.readByte();
            while (!buffer.isFinished()) {
                IpAddressShare address = new IpAddressShare();
                address.parse(buffer);
                this.ipAddressList.add(address);
            }
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public byte getIsCross() {
        return this.isCross;
    }

    public void setIsCross(byte isCross) {
        this.isCross = isCross;
    }

    public List<IpAddressShare> getIpAddressList() {
        return this.ipAddressList;
    }

    public void setIpAddressList(List<IpAddressShare> ipAddressList) {
        this.ipAddressList = ipAddressList;
    }
}

