/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.netty.codec.NulsLengthFieldBasedFrameDecoder;
import io.nuls.network.utils.LoggerUtil;
import java.nio.ByteOrder;
import java.util.List;

public class NulsMessageDecoder
extends ByteToMessageDecoder {
    private NulsLengthFieldBasedFrameDecoder newDecoder = new NulsLengthFieldBasedFrameDecoder(ByteOrder.LITTLE_ENDIAN, 0xA00000, 4, 4, 16, 0, true);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        long readMagicNumber = in.getUnsignedIntLE(0);
        if (NodeGroupManager.getInstance().validMagicNumber(readMagicNumber)) {
            Object decoded = this.newDecoder.decode(ctx, in);
            if (decoded != null) {
                out.add(decoded);
            }
        } else {
            LoggerUtil.COMMON_LOG.error("readMagicNumber={} illegal message REC", new Object[]{readMagicNumber});
            in.clear();
            ctx.close();
        }
    }
}

