/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.protocol.manager;

import io.nuls.base.basic.ProtocolVersion;
import io.nuls.common.ConfigBean;
import io.nuls.protocol.model.ProtocolContext;
import io.nuls.protocol.utils.LoggerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ContextManager {
    static List<Integer> chainIds = new CopyOnWriteArrayList<Integer>();
    private static Map<Integer, ProtocolContext> contextMap = new ConcurrentHashMap<Integer, ProtocolContext>();

    private ContextManager() {
    }

    public static void init(ConfigBean parameter, List<ProtocolVersion> versions) {
        ProtocolContext protocolContext = new ProtocolContext();
        int chainId = parameter.getChainId();
        chainIds.add(chainId);
        contextMap.put(chainId, protocolContext);
        protocolContext.setChainId(chainId);
        protocolContext.setParameters(parameter);
        versions.sort(ProtocolVersion.COMPARATOR);
        protocolContext.setLocalVersionList(versions);
        protocolContext.init();
        LoggerUtil.init(chainId);
        LoggerUtil.COMMON_LOG.info("new protocolContext add! chainId-" + chainId);
    }

    public static ProtocolContext getContext(int chainId) {
        return contextMap.get(chainId);
    }
}

