/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.cache;

import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteArrayWrapper;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import java.util.List;
import java.util.Map;

@Component
public class PackablePool {
    @Autowired
    private UnconfirmedTxStorageService unconfirmedTxStorageService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirst(Chain chain, Transaction tx) {
        ByteArrayWrapper hash;
        ByteArrayWrapper byteArrayWrapper = hash = new ByteArrayWrapper(tx.getHash().getBytes());
        synchronized (byteArrayWrapper) {
            if (chain.getPackableHashQueue().offerFirst(hash)) {
                chain.getPackableTxMap().put(hash, tx);
                return true;
            }
        }
        chain.getLogger().error("PackableHashQueue offerFirst false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirstOnlyHash(Chain chain, Transaction tx) {
        ByteArrayWrapper hash;
        ByteArrayWrapper byteArrayWrapper = hash = new ByteArrayWrapper(tx.getHash().getBytes());
        synchronized (byteArrayWrapper) {
            if (chain.getPackableHashQueue().offerFirst(hash)) {
                return true;
            }
        }
        chain.getLogger().error("PackableHashQueue offerFirst false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Chain chain, Transaction tx) {
        ByteArrayWrapper hash;
        ByteArrayWrapper byteArrayWrapper = hash = new ByteArrayWrapper(tx.getHash().getBytes());
        synchronized (byteArrayWrapper) {
            if (chain.getPackableHashQueue().offer(hash)) {
                chain.getPackableTxMap().put(hash, tx);
                return true;
            }
        }
        chain.getLogger().error("PackableHashQueue add false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction poll(Chain chain) {
        ByteArrayWrapper hash;
        while (null != (hash = chain.getPackableHashQueue().poll())) {
            ByteArrayWrapper byteArrayWrapper = hash;
            synchronized (byteArrayWrapper) {
                Transaction tx = chain.getPackableTxMap().get(hash);
                if (null != tx) {
                    return tx;
                }
                this.unconfirmedTxStorageService.removeTx(chain.getChainId(), hash.getBytes());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction pollLast(Chain chain) {
        ByteArrayWrapper hash;
        while (null != (hash = (ByteArrayWrapper)chain.getPackableHashQueue().pollLast())) {
            ByteArrayWrapper byteArrayWrapper = hash;
            synchronized (byteArrayWrapper) {
                Transaction tx = chain.getPackableTxMap().get(hash);
                if (null != tx) {
                    return tx;
                }
                this.unconfirmedTxStorageService.removeTx(chain.getChainId(), hash.getBytes());
            }
        }
        return null;
    }

    public void clearConfirmedTxs(Chain chain, List<byte[]> txHashs) {
        Map<ByteArrayWrapper, Transaction> map = chain.getPackableTxMap();
        for (byte[] hash : txHashs) {
            ByteArrayWrapper wrapper = new ByteArrayWrapper(hash);
            map.remove(wrapper);
        }
    }

    public void removeInvalidTxFromMap(Chain chain, Transaction tx) {
        Map<ByteArrayWrapper, Transaction> map = chain.getPackableTxMap();
        ByteArrayWrapper wrapper = new ByteArrayWrapper(tx.getHash().getBytes());
        map.remove(wrapper);
    }

    public boolean exist(Chain chain, Transaction tx) {
        ByteArrayWrapper hash = new ByteArrayWrapper(tx.getHash().getBytes());
        return chain.getPackableHashQueue().contains(hash);
    }

    public int packableHashQueueSize(Chain chain) {
        return chain.getPackableHashQueue().size();
    }

    public int packableTxMapSize(Chain chain) {
        return chain.getPackableTxMap().size();
    }

    public void clear(Chain chain) {
        chain.getPackableHashQueue().clear();
    }
}

