/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.manager;

import io.nuls.common.CommonContext;
import io.nuls.common.ConfigBean;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.transaction.manager.SchedulerManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.utils.LoggerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

@Component
public class ChainManager {
    @Autowired
    private SchedulerManager schedulerManager;
    @Autowired
    private NulsCoresConfig txConfig;
    private Map<Integer, Chain> chainMap = new ConcurrentHashMap<Integer, Chain>();

    public ChainManager() {
    }

    public ChainManager(SchedulerManager schedulerManager, NulsCoresConfig txConfig) {
        this.schedulerManager = schedulerManager;
        this.txConfig = txConfig;
    }

    public void initChain() throws Exception {
        Map<Integer, ConfigBean> configMap = this.configChain();
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, ConfigBean> entry : configMap.entrySet()) {
            Chain chain = new Chain();
            int chainId = entry.getKey();
            chain.setConfig(entry.getValue());
            this.initLogger(chain);
            this.initTable(chain);
            this.chainMap.put(chainId, chain);
            chain.getLogger().debug("Chain:{} init success..", new Object[]{chainId});
        }
    }

    public void runChain() throws Exception {
        for (Chain chain : this.chainMap.values()) {
            this.initCache(chain);
            this.schedulerManager.createTransactionScheduler(chain);
            this.chainMap.put(chain.getChainId(), chain);
            chain.getLogger().debug("Chain:{} runChain success..", new Object[]{chain.getChainId()});
        }
    }

    public void stopChain(int chainId) {
    }

    private Map<Integer, ConfigBean> configChain() {
        try {
            Map<Integer, ConfigBean> configMap = CommonContext.CONFIG_BEAN_MAP;
            if (configMap.isEmpty()) {
                NulsCoresConfig configBean = this.txConfig;
                configMap.put(((ConfigBean)configBean).getChainId(), configBean);
            }
            return configMap;
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            return null;
        }
    }

    private void initTable(Chain chain) {
        block3: {
            NulsLogger logger = chain.getLogger();
            int chainId = chain.getConfig().getChainId();
            try {
                if (RocksDBService.existTable((String)("tx_table_unconfirmed_" + chainId))) {
                    RocksDBService.destroyTable((String)("tx_table_unconfirmed_" + chainId));
                }
                RocksDBService.createTable((String)("tx_table_confirmed_" + chainId));
                RocksDBService.createTable((String)("tx_table_unconfirmed_" + chainId));
            }
            catch (Exception e) {
                if ("DB table exists".equals(e.getMessage())) break block3;
                logger.error(e);
            }
        }
    }

    private void initCache(Chain chain) {
        LinkedBlockingDeque<TransactionNetPO> unverifiedQueue = new LinkedBlockingDeque<TransactionNetPO>((int)this.txConfig.getTxUnverifiedQueueSize());
        chain.setUnverifiedQueue(unverifiedQueue);
    }

    private void initLogger(Chain chain) {
        LoggerUtil.init(chain);
    }

    public Map<Integer, Chain> getChainMap() {
        return this.chainMap;
    }

    public void setChainMap(Map<Integer, Chain> chainMap) {
        this.chainMap = chainMap;
    }

    public boolean containsKey(int key) {
        return this.chainMap.containsKey(key);
    }

    public Chain getChain(int key) {
        return this.chainMap.get(key);
    }
}

