/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.model.bo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.ConfigBean;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.ByteArrayWrapper;
import io.nuls.transaction.model.bo.Orphans;
import io.nuls.transaction.model.bo.TxRegister;
import io.nuls.transaction.model.po.TransactionNetPO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Chain {
    private ConfigBean config;
    private AtomicBoolean packaging;
    private AtomicBoolean processTxStatus;
    private NulsLogger logger;
    private Map<Integer, TxRegister> txRegisterMap;
    private BlockingDeque<ByteArrayWrapper> packableHashQueue;
    private Map<ByteArrayWrapper, Transaction> packableTxMap;
    private BlockingDeque<TransactionNetPO> unverifiedQueue;
    private LinkedList<TransactionNetPO> orphanList;
    private Map<String, Orphans> orphanMap;
    private AtomicInteger orphanListDataSize;
    private long bestBlockHeight;
    @JsonIgnore
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private boolean contractTxFail = false;
    private Map<NulsHash, Integer> txPackageOrphanMap;
    private final Lock packageLock = new ReentrantLock();
    private AtomicBoolean packableState;
    private AtomicBoolean protocolUpgrade;
    private AtomicBoolean canProtocolUpgrade;
    private Set<Integer> contractGenerateTxTypes;

    public Chain() {
        this.packaging = new AtomicBoolean(false);
        this.packableState = new AtomicBoolean(true);
        this.processTxStatus = new AtomicBoolean(false);
        this.txRegisterMap = new ConcurrentHashMap<Integer, TxRegister>(32);
        this.packableHashQueue = new LinkedBlockingDeque<ByteArrayWrapper>();
        this.packableTxMap = new ConcurrentHashMap<ByteArrayWrapper, Transaction>();
        this.txPackageOrphanMap = new HashMap<NulsHash, Integer>();
        this.orphanList = new LinkedList();
        this.orphanMap = new ConcurrentHashMap<String, Orphans>();
        this.protocolUpgrade = new AtomicBoolean(false);
        this.canProtocolUpgrade = new AtomicBoolean(true);
        this.orphanListDataSize = new AtomicInteger(0);
        this.contractGenerateTxTypes = new HashSet<Integer>();
    }

    public int getChainId() {
        return this.config.getChainId();
    }

    public ConfigBean getConfig() {
        return this.config;
    }

    public void setConfig(ConfigBean config) {
        this.config = config;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
    }

    public NulsLogger getLogger() {
        return this.logger;
    }

    public void setLogger(NulsLogger logger) {
        this.logger = logger;
    }

    public Map<Integer, TxRegister> getTxRegisterMap() {
        return this.txRegisterMap;
    }

    public void setTxRegisterMap(Map<Integer, TxRegister> txRegisterMap) {
        this.txRegisterMap = txRegisterMap;
    }

    public BlockingDeque<ByteArrayWrapper> getPackableHashQueue() {
        return this.packableHashQueue;
    }

    public void setPackableHashQueue(BlockingDeque<ByteArrayWrapper> packableHashQueue) {
        this.packableHashQueue = packableHashQueue;
    }

    public Map<ByteArrayWrapper, Transaction> getPackableTxMap() {
        return this.packableTxMap;
    }

    public void setPackableTxMap(Map<ByteArrayWrapper, Transaction> packableTxMap) {
        this.packableTxMap = packableTxMap;
    }

    public long getBestBlockHeight() {
        return this.bestBlockHeight;
    }

    public void setBestBlockHeight(long bestBlockHeight) {
        this.bestBlockHeight = bestBlockHeight;
    }

    public AtomicBoolean getPackaging() {
        return this.packaging;
    }

    public AtomicBoolean getProcessTxStatus() {
        return this.processTxStatus;
    }

    public boolean getContractTxFail() {
        return this.contractTxFail;
    }

    public void setContractTxFail(boolean contractTxFail) {
        this.contractTxFail = contractTxFail;
    }

    public Map<NulsHash, Integer> getTxPackageOrphanMap() {
        return this.txPackageOrphanMap;
    }

    public Lock getPackageLock() {
        return this.packageLock;
    }

    public void setTxPackageOrphanMap(Map<NulsHash, Integer> txPackageOrphanMap) {
        this.txPackageOrphanMap = txPackageOrphanMap;
    }

    public BlockingDeque<TransactionNetPO> getUnverifiedQueue() {
        return this.unverifiedQueue;
    }

    public void setUnverifiedQueue(BlockingDeque<TransactionNetPO> unverifiedQueue) {
        this.unverifiedQueue = unverifiedQueue;
    }

    public LinkedList<TransactionNetPO> getOrphanList() {
        return this.orphanList;
    }

    public void setOrphanList(LinkedList<TransactionNetPO> orphanList) {
        this.orphanList = orphanList;
    }

    public Map<String, Orphans> getOrphanMap() {
        return this.orphanMap;
    }

    public void setOrphanMap(Map<String, Orphans> orphanMap) {
        this.orphanMap = orphanMap;
    }

    public AtomicBoolean getProtocolUpgrade() {
        return this.protocolUpgrade;
    }

    public AtomicBoolean getCanProtocolUpgrade() {
        return this.canProtocolUpgrade;
    }

    public void setCanProtocolUpgrade(AtomicBoolean canProtocolUpgrade) {
        this.canProtocolUpgrade = canProtocolUpgrade;
    }

    public AtomicBoolean getPackableState() {
        return this.packableState;
    }

    public AtomicInteger getOrphanListDataSize() {
        return this.orphanListDataSize;
    }

    public Set<Integer> getContractGenerateTxTypes() {
        return this.contractGenerateTxTypes;
    }

    public void setContractGenerateTxTypes(Set<Integer> contractGenerateTxTypes) {
        this.contractGenerateTxTypes = contractGenerateTxTypes;
    }
}

