/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.model.bo;

import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Orphans {
    private TransactionNetPO tx;
    private Orphans next;
    private List<CoinFrom> coinFromList;

    public Orphans(TransactionNetPO tx) {
        this.tx = tx;
        this.coinFromList = this.getCoinFromList();
    }

    public Orphans(TransactionNetPO tx, Orphans next) {
        this.tx = tx;
        this.next = next;
        this.coinFromList = this.getCoinFromList();
    }

    public TransactionNetPO getTx() {
        return this.tx;
    }

    public void setTx(TransactionNetPO tx) {
        this.tx = tx;
    }

    public Orphans getNext() {
        return this.next;
    }

    public void setNext(Orphans next) {
        this.next = next;
    }

    private List<CoinFrom> getCoinFromList() {
        try {
            CoinData coinData = this.tx.getTx().getCoinDataInstance();
            return coinData.getFrom();
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            return new ArrayList<CoinFrom>();
        }
    }

    public boolean isNextTx(TransactionNetPO txNet) {
        byte[] hashSuffix = TxUtil.getNonce(txNet.getTx().getHash().getBytes());
        for (CoinFrom coinFrom : this.coinFromList) {
            if (!Arrays.equals(hashSuffix, coinFrom.getNonce())) continue;
            return true;
        }
        return false;
    }

    public boolean isPrevTx(TransactionNetPO txNet) {
        try {
            CoinData coinData = txNet.getTx().getCoinDataInstance();
            byte[] hashSuffix = TxUtil.getNonce(this.tx.getTx().getHash().getBytes());
            for (CoinFrom coinFrom : coinData.getFrom()) {
                if (!Arrays.equals(hashSuffix, coinFrom.getNonce())) continue;
                return true;
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        return false;
    }
}

