/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.transaction.constant.TxConstant;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.VerifyLedgerResult;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.rpc.call.TransactionCall;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LedgerCall {
    public static VerifyLedgerResult verifyCoinData(Chain chain, String tx) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("tx", tx);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "verifyCoinData", params);
            return VerifyLedgerResult.success((Boolean)result.get("orphan"));
        }
        catch (NulsException e) {
            return VerifyLedgerResult.fail(e.getErrorCode());
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return VerifyLedgerResult.fail(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static VerifyLedgerResult commitUnconfirmedTx(Chain chain, String txStr) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("tx", txStr);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "commitUnconfirmedTx", params);
            Boolean orphan = (Boolean)result.get("orphan");
            if (null == orphan) {
                chain.getLogger().error("call commitUnconfirmedTx response orphan is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return VerifyLedgerResult.fail(TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND);
            }
            return VerifyLedgerResult.success(orphan);
        }
        catch (NulsException e) {
            return VerifyLedgerResult.fail(e.getErrorCode());
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return VerifyLedgerResult.fail(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static Map commitBatchUnconfirmedTxs(Chain chain, List<TransactionNetPO> txNetList) throws NulsException {
        try {
            ArrayList<String> txStrList = new ArrayList<String>();
            for (TransactionNetPO txNet : txNetList) {
                txStrList.add(RPCUtil.encode((byte[])txNet.getTx().serialize()));
            }
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("txList", txStrList);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "commitBatchUnconfirmedTxs", params);
            return result;
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.SERIALIZE_ERROR);
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static VerifyLedgerResult verifyCoinDataPackaged(Chain chain, String tx) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("tx", tx);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "verifyCoinDataPackaged", params);
            Boolean orphan = (Boolean)result.get("orphan");
            if (null == orphan) {
                chain.getLogger().error("call verifyCoinDataPackaged response orphan is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return VerifyLedgerResult.fail(TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND);
            }
            return VerifyLedgerResult.success(orphan);
        }
        catch (NulsException e) {
            return VerifyLedgerResult.fail(e.getErrorCode());
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return VerifyLedgerResult.fail(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static Map verifyCoinDataBatchPackaged(Chain chain, List<String> txStrList) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("txList", txStrList);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "verifyCoinDataBatchPackaged", params);
            return result;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean verifyBlockTxsCoinData(Chain chain, List<String> txList, Long blockHeight) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("txList", txList);
            params.put("blockHeight", blockHeight);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "blockValidate", params);
            Boolean value = (Boolean)result.get("value");
            if (null == value) {
                chain.getLogger().error("call blockValidate response value is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return false;
            }
            return value;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static byte[] getNonce(Chain chain, String address, int assetChainId, int assetId) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("address", address);
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "getNonce", params);
            String nonce = (String)result.get("nonce");
            if (null == nonce) {
                chain.getLogger().error("call getNonce response nonce is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return TxConstant.DEFAULT_NONCE;
            }
            return RPCUtil.decode((String)nonce);
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static BigInteger getBalance(Chain chain, byte[] address, int assetChainId, int assetId) throws NulsException {
        try {
            String addressString = AddressTool.getStringAddressByBytes((byte[])address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            params.put("address", addressString);
            Map result = (Map)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "getBalance", params);
            Object available = result.get("available");
            if (null == available) {
                chain.getLogger().error("call getBalance response available is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return new BigInteger("0");
            }
            return BigIntegerUtils.stringToBigInteger((String)String.valueOf(available));
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean coinDataBatchNotify(Chain chain) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "batchValidateBegin", params);
            Boolean value = (Boolean)result.get("value");
            if (null == value) {
                chain.getLogger().error("call batchValidateBegin response value is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return false;
            }
            return value;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean commitTxsLedger(Chain chain, List<String> txList, Long blockHeight) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("txList", txList);
            params.put("blockHeight", blockHeight);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "commitBlockTxs", params, 600000L);
            Boolean value = (Boolean)result.get("value");
            if (null == value) {
                chain.getLogger().error("call commitBlockTxs response value is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return false;
            }
            return value;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean rollbackTxValidateStatus(Chain chain, String txStr) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("tx", txStr);
            Request request = MessageUtil.newRequest((String)"rollbackTxValidateStatus", params, (String)"1", (String)"0", (String)"0");
            String messageId = ResponseMessageProcessor.requestOnly((String)ModuleE.LG.abbr, (Request)request);
            return !messageId.equals("0");
        }
        catch (Exception e) {
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean rollBackUnconfirmTx(Chain chain, String txStr) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("tx", txStr);
            Request request = MessageUtil.newRequest((String)"rollBackUnconfirmTx", params, (String)"1", (String)"0", (String)"0");
            String messageId = ResponseMessageProcessor.requestOnly((String)ModuleE.LG.abbr, (Request)request);
            return !messageId.equals("0");
        }
        catch (Exception e) {
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean rollbackTxsLedger(Chain chain, List<String> txList, Long blockHeight) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("txList", txList);
            params.put("blockHeight", blockHeight);
            HashMap result = (HashMap)TransactionCall.requestAndResponse(ModuleE.LG.abbr, "rollBackBlockTxs", params, 600000L);
            Boolean value = (Boolean)result.get("value");
            if (null == value) {
                chain.getLogger().error("call rollBackBlockTxs response value is null, error:{}", new Object[]{TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return false;
            }
            return value;
        }
        catch (RuntimeException e) {
            chain.getLogger().error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static void clearUnconfirmTxs(Chain chain) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            TransactionCall.requestAndResponse(ModuleE.LG.abbr, "clearUnconfirmTxs", params);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
    }
}

