/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.call;

import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionCall {
    public static Object requestAndResponse(String moduleCode, String cmd, Map params) throws NulsException {
        return TransactionCall.requestAndResponse(moduleCode, cmd, params, null);
    }

    public static Object requestAndResponse(String moduleCode, String cmd, Map params, Long timeout) throws NulsException {
        try {
            params.put("version", "1.0");
            Response response = null;
            try {
                response = null == timeout ? ResponseMessageProcessor.requestAndResponse((String)moduleCode, (String)cmd, (Map)params) : ResponseMessageProcessor.requestAndResponse((String)moduleCode, (String)cmd, (Map)params, (long)timeout);
            }
            catch (Exception e) {
                LoggerUtil.LOG.error(e);
                throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
            }
            if (!response.isSuccess()) {
                String errorCode = response.getResponseErrorCode();
                LoggerUtil.LOG.error("Call interface [{}] error, ErrorCode is {}, ResponseComment:{}", new Object[]{cmd, errorCode, response.getResponseComment()});
                throw new NulsException(ErrorCode.init((String)errorCode));
            }
            Map data = (Map)response.getResponseData();
            return data.get(cmd);
        }
        catch (RuntimeException e) {
            LoggerUtil.LOG.error((Exception)e);
            throw new NulsException(TxErrorCode.RPC_REQUEST_FAILD);
        }
    }

    public static boolean txProcess(Chain chain, String cmd, String moduleCode, List<String> txList, String blockHeader) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("chainId", chain.getChainId());
            params.put("txList", txList);
            params.put("blockHeader", blockHeader);
            Map result = (Map)TransactionCall.requestAndResponse(moduleCode, cmd, params, 600000L);
            Boolean value = (Boolean)result.get("value");
            if (null == value) {
                chain.getLogger().error("call module-{} {} response value is null, error:{}", new Object[]{moduleCode, cmd, TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return false;
            }
            return value;
        }
        catch (Exception e) {
            chain.getLogger().error("call module-{} {} error, error:{}", new Object[]{moduleCode, "txProcess", e});
            return false;
        }
    }

    public static Map<String, Object> txModuleValidator(Chain chain, String moduleCode, String tx) throws NulsException {
        ArrayList<String> txList = new ArrayList<String>();
        txList.add(tx);
        return TransactionCall.callTxModuleValidator(chain, moduleCode, txList, null);
    }

    public static List<String> txModuleValidator(Chain chain, String moduleCode, List<String> txList) throws NulsException {
        return TransactionCall.txModuleValidator(chain, moduleCode, txList, null);
    }

    public static List<String> txModuleValidator(Chain chain, String moduleCode, List<String> txList, String blockHeaderStr) throws NulsException {
        Map<String, Object> result = TransactionCall.callTxModuleValidator(chain, moduleCode, txList, blockHeaderStr);
        return (List)result.get("list");
    }

    private static Map<String, Object> callTxModuleValidator(Chain chain, String moduleCode, List<String> txList, String blockHeaderStr) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("chainId", chain.getChainId());
        params.put("txList", txList);
        params.put("blockHeader", blockHeaderStr);
        Map responseMap = (Map)TransactionCall.requestAndResponse(moduleCode, "txValidator", params);
        List list = (List)responseMap.get("list");
        if (null == list) {
            chain.getLogger().error("call txModuleValidator-{} {} response value is null, error:{}", new Object[]{moduleCode, "txValidator", TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
            throw new NulsException(TxErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND);
        }
        String errorCode = (String)responseMap.get("errorCode");
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("list", list);
        result.put("errorCode", errorCode);
        return result;
    }
}

