/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.VerifyLedgerResult;
import io.nuls.transaction.model.bo.VerifyResult;
import io.nuls.transaction.model.po.TransactionConfirmedPO;
import io.nuls.transaction.rpc.call.LedgerCall;
import io.nuls.transaction.service.ConfirmedTxService;
import io.nuls.transaction.service.TxService;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import io.nuls.transaction.utils.LoggerUtil;
import io.nuls.transaction.utils.TxUtil;
import java.util.HashMap;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.TX)
public class ClientCmd
extends BaseCmd {
    @Autowired
    private TxService txService;
    @Autowired
    private ConfirmedTxService confirmedTxService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private UnconfirmedTxStorageService unconfirmedTxStorageService;
    @Autowired
    private PackablePool packablePool;

    @CmdAnnotation(cmd="tx_getTxClient", version=1.0, description="according tohashObtain the transaction, first check for unconfirmed information, then check for confirmed information if not found/Get transaction by tx hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="Transaction to be queriedhash")})
    @ResponseData(name="Return value", description="Return aMapObject, containing threekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="The string of serialized data obtained from the transaction"), @Key(name="height", description="The confirmation height of the transaction obtained, while the unconfirmed transaction height is-1"), @Key(name="status", description="The status of whether the obtained transaction is confirmed or not")}))
    public Response getTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHash"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txHash = (String)params.get("txHash");
            if (!NulsHash.validHash((String)txHash)) {
                throw new NulsException(TxErrorCode.HASH_ERROR);
            }
            TransactionConfirmedPO tx = this.txService.getTransaction(chain, NulsHash.fromHex((String)txHash));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            if (tx == null) {
                resultMap.put("tx", null);
            } else {
                resultMap.put("tx", RPCUtil.encode((byte[])tx.getTx().serialize()));
                resultMap.put("height", tx.getBlockHeight());
                resultMap.put("status", tx.getStatus());
            }
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_getConfirmedTxClient", version=1.0, description="according tohashObtain confirmed transactions(Only check confirmed)/Get confirmed transaction by tx hash")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="txHash", parameterType="String", parameterDes="Transaction to be queriedhash")})
    @ResponseData(name="Return value", description="Return aMapObject, containing threekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="The string of serialized data obtained from the transaction"), @Key(name="height", description="The confirmation height of the transaction obtained"), @Key(name="status", description="The status of whether the obtained transaction is confirmed or not")}))
    public Response getConfirmedTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("txHash"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txHash = (String)params.get("txHash");
            if (!NulsHash.validHash((String)txHash)) {
                throw new NulsException(TxErrorCode.HASH_ERROR);
            }
            TransactionConfirmedPO tx = this.confirmedTxService.getConfirmedTransaction(chain, NulsHash.fromHex((String)txHash));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            if (tx == null) {
                LoggerUtil.LOG.debug("getConfirmedTransaction fail, tx is null. txHash:{}", new Object[]{txHash});
                resultMap.put("tx", null);
            } else {
                LoggerUtil.LOG.debug("getConfirmedTransaction success. txHash:{}", new Object[]{txHash});
                resultMap.put("tx", RPCUtil.encode((byte[])tx.getTx().serialize()));
                resultMap.put("height", tx.getBlockHeight());
                resultMap.put("status", tx.getStatus());
            }
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="tx_verifyTx", version=1.0, description="Verify transaction interfaces, including basic verification\u3001Validator\u3001Ledger verification/Verify transation")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="tx", parameterType="String", parameterDes="Complete transaction string to be verified")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public Response verifyTx(Map params) {
        Chain chain = null;
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            ObjectUtils.canNotEmpty(params.get("tx"), (String)TxErrorCode.PARAMETER_ERROR.getMsg());
            chain = this.chainManager.getChain((Integer)params.get("chainId"));
            if (null == chain) {
                throw new NulsException(TxErrorCode.CHAIN_NOT_FOUND);
            }
            String txStr = (String)params.get("tx");
            Transaction tx = (Transaction)TxUtil.getInstanceRpcStr(txStr, Transaction.class);
            VerifyResult verifyResult = this.txService.verify(chain, tx);
            if (!verifyResult.getResult()) {
                return this.failed(verifyResult.getErrorCode());
            }
            VerifyLedgerResult verifyLedgerResult = LedgerCall.verifyCoinData(chain, RPCUtil.encode((byte[])tx.serialize()));
            if (!verifyLedgerResult.getSuccess()) {
                return this.failed(verifyLedgerResult.getErrorCode());
            }
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            resultMap.put("value", tx.getHash().toHex());
            return this.success(resultMap);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(TxErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

