/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.rpc.upgrade;

import io.nuls.base.data.Transaction;
import io.nuls.core.basic.VersionChangeInvoker;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.transaction.cache.PackablePool;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.manager.ChainManager;
import io.nuls.transaction.manager.TxManager;
import io.nuls.transaction.model.bo.Chain;
import io.nuls.transaction.model.bo.TxRegister;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.rpc.call.LedgerCall;
import io.nuls.transaction.service.TxService;

public class TxVersionChangeInvoker
implements VersionChangeInvoker {
    private static TxVersionChangeInvoker txVersionChangeInvoker = new TxVersionChangeInvoker();

    private TxVersionChangeInvoker() {
    }

    public static TxVersionChangeInvoker instance() {
        return txVersionChangeInvoker;
    }

    public void process(int chainId) {
        ChainManager chainManager = (ChainManager)SpringLiteContext.getBean(ChainManager.class);
        Chain chain = chainManager.getChain(chainId);
        if (null == chain) {
            Log.error((String)TxErrorCode.CHAIN_NOT_FOUND.getCode());
            return;
        }
        chain.getProtocolUpgrade().set(true);
        try {
            Thread.sleep(3000L);
            while (!chain.getCanProtocolUpgrade().get()) {
                chain.getLogger().info("GetCanProtocolUpgrade waiting, chainId:[{}]", new Object[]{chainId});
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            chain.getLogger().error((Exception)e);
        }
        PackablePool packablePool = (PackablePool)SpringLiteContext.getBean(PackablePool.class);
        boolean hasNext = true;
        while (hasNext) {
            Transaction tx = packablePool.pollLast(chain);
            if (null != tx) {
                this.addBack(chain, tx);
                continue;
            }
            hasNext = false;
        }
        LedgerCall.clearUnconfirmTxs(chain);
        chain.getProtocolUpgrade().set(false);
        chain.getLogger().info("Version Change process, chainId:[{}]", new Object[]{chainId});
    }

    private void addBack(Chain chain, Transaction tx) {
        this.addBack(chain, new TransactionNetPO(tx));
    }

    private void addBack(Chain chain, TransactionNetPO txNet) {
        try {
            Transaction tx = txNet.getTx();
            TxRegister txRegister = TxManager.getTxRegister(chain, tx.getType());
            if (null == txRegister) {
                throw new NulsException(TxErrorCode.TX_TYPE_INVALID);
            }
            TxService txService = (TxService)SpringLiteContext.getBean(TxService.class);
            txService.baseValidateTx(chain, tx, txRegister);
            chain.getUnverifiedQueue().addFirst(txNet);
        }
        catch (NulsException e) {
            chain.getLogger().warn("TxVersionChangeInvoker verify failed", (Throwable)e);
        }
    }
}

