/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.transaction.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.transaction.constant.TxErrorCode;
import io.nuls.transaction.model.po.TransactionNetPO;
import io.nuls.transaction.model.po.TransactionUnconfirmedPO;
import io.nuls.transaction.storage.UnconfirmedTxStorageService;
import io.nuls.transaction.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class UnconfirmedTxStorageServiceImpl
implements UnconfirmedTxStorageService {
    @Override
    public boolean putTx(int chainId, Transaction tx) {
        if (tx == null) {
            return false;
        }
        TransactionUnconfirmedPO txPO = new TransactionUnconfirmedPO(tx, NulsDateUtils.getCurrentTimeSeconds());
        byte[] txHashBytes = tx.getHash().getBytes();
        boolean result = false;
        try {
            result = RocksDBService.put((String)("tx_table_unconfirmed_" + chainId), (byte[])txHashBytes, (byte[])txPO.serialize());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        return result;
    }

    @Override
    public boolean putTxList(int chainId, List<TransactionNetPO> txNetPOList) {
        if (null == txNetPOList || txNetPOList.size() == 0) {
            throw new NulsRuntimeException(TxErrorCode.PARAMETER_ERROR);
        }
        HashMap<byte[], byte[]> txPOMap = new HashMap<byte[], byte[]>();
        try {
            for (TransactionNetPO txNetPO : txNetPOList) {
                Transaction tx = txNetPO.getTx();
                TransactionUnconfirmedPO txPO = new TransactionUnconfirmedPO(tx, NulsDateUtils.getCurrentTimeSeconds());
                txPOMap.put(tx.getHash().getBytes(), txPO.serialize());
            }
            return RocksDBService.batchPut((String)("tx_table_unconfirmed_" + chainId), txPOMap);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(TxErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public TransactionUnconfirmedPO getTx(int chainId, NulsHash hash) {
        if (hash == null) {
            return null;
        }
        return this.getTx(chainId, hash.getBytes());
    }

    @Override
    public boolean isExists(int chainId, NulsHash hash) {
        byte[] txBytes = RocksDBService.get((String)("tx_table_unconfirmed_" + chainId), (byte[])hash.getBytes());
        return null != txBytes && txBytes.length > 0;
    }

    @Override
    public TransactionUnconfirmedPO getTx(int chainId, String hash) {
        if (StringUtils.isBlank((String)hash)) {
            return null;
        }
        return this.getTx(chainId, HexUtil.decode((String)hash));
    }

    private TransactionUnconfirmedPO getTx(int chainId, byte[] hashSerialize) {
        byte[] txBytes = RocksDBService.get((String)("tx_table_unconfirmed_" + chainId), (byte[])hashSerialize);
        TransactionUnconfirmedPO txPO = null;
        if (null != txBytes) {
            try {
                txPO = new TransactionUnconfirmedPO();
                txPO.parse(new NulsByteBuffer(txBytes, 0));
            }
            catch (Exception e) {
                LoggerUtil.LOG.error(e);
                return null;
            }
        }
        return txPO;
    }

    @Override
    public boolean removeTx(int chainId, NulsHash hash) {
        if (hash == null) {
            return false;
        }
        return this.removeTx(chainId, hash.getBytes());
    }

    @Override
    public boolean removeTx(int chainId, byte[] hash) {
        boolean result = false;
        try {
            result = RocksDBService.delete((String)("tx_table_unconfirmed_" + chainId), (byte[])hash);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        return result;
    }

    @Override
    public List<Transaction> getTxList(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return null;
        }
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        List list = RocksDBService.multiGetAsList((String)("tx_table_unconfirmed_" + chainId), hashList);
        if (list != null) {
            for (byte[] txBytes : list) {
                Transaction tx = new Transaction();
                try {
                    TransactionUnconfirmedPO txPO = new TransactionUnconfirmedPO();
                    txPO.parse(txBytes, 0);
                    tx = txPO.getTx();
                }
                catch (NulsException e) {
                    LoggerUtil.LOG.error(e);
                }
                txList.add(tx);
            }
        }
        return txList;
    }

    @Override
    public boolean removeTxList(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return true;
        }
        try {
            return RocksDBService.deleteKeys((String)("tx_table_unconfirmed_" + chainId), hashList);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            return false;
        }
    }

    @Override
    public List<byte[]> getAllTxkeyList(int chainId) {
        return RocksDBService.keyList((String)("tx_table_unconfirmed_" + chainId));
    }

    @Override
    public List<TransactionUnconfirmedPO> getTransactionUnconfirmedPOList(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return null;
        }
        ArrayList<TransactionUnconfirmedPO> txPOList = new ArrayList<TransactionUnconfirmedPO>();
        List list = RocksDBService.multiGetAsList((String)("tx_table_unconfirmed_" + chainId), hashList);
        if (list != null) {
            for (byte[] txBytes : list) {
                TransactionUnconfirmedPO txPO = new TransactionUnconfirmedPO();
                try {
                    txPO.parse(txBytes, 0);
                }
                catch (NulsException e) {
                    LoggerUtil.LOG.error(e);
                }
                txPOList.add(txPO);
            }
        }
        return txPOList;
    }

    @Override
    public List<byte[]> getExistKeys(int chainId, List<byte[]> hashList) {
        if (hashList == null || hashList.size() == 0) {
            return null;
        }
        return RocksDBService.multiGetKeyList((String)("tx_table_unconfirmed_" + chainId), hashList);
    }

    @Override
    public List<String> getExistKeysStr(int chainId, List<byte[]> hashList) {
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] hash : this.getExistKeys(chainId, hashList)) {
            list.add(HexUtil.encode((byte[])hash));
        }
        return list;
    }
}

