/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.config;

import org.ethereum.config.CommonConfig;
import org.ethereum.config.SystemProperties;
import org.ethereum.datasource.Source;
import org.ethereum.db.BlockStore;
import org.ethereum.db.IndexedBlockStore;
import org.ethereum.db.PruneManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfig {
    private static Logger logger = LoggerFactory.getLogger((String)"general");
    CommonConfig commonConfig;
    SystemProperties config = SystemProperties.getDefault();
    private BlockStore blockStore;
    private PruneManager pruneManager;

    public static DefaultConfig newInstance(CommonConfig commonConfig) {
        DefaultConfig defaultConfig = new DefaultConfig();
        defaultConfig.commonConfig = commonConfig;
        return defaultConfig;
    }

    public DefaultConfig() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error("Uncaught exception", e));
    }

    public BlockStore blockStore() {
        if (this.blockStore == null) {
            IndexedBlockStore indexedBlockStore = new IndexedBlockStore();
            Source<byte[], byte[]> block = this.commonConfig.cachedDbSource("block");
            Source<byte[], byte[]> index = this.commonConfig.cachedDbSource("index");
            indexedBlockStore.init(index, block);
            this.blockStore = indexedBlockStore;
        }
        return this.blockStore;
    }

    public PruneManager pruneManager() {
        if (this.pruneManager == null) {
            this.pruneManager = this.config.databasePruneDepth() >= 0 ? new PruneManager((IndexedBlockStore)this.blockStore(), this.commonConfig.stateSource().getJournalSource(), this.commonConfig.stateSource().getNoJournalSource(), this.config.databasePruneDepth()) : new PruneManager(null, null, null, -1);
        }
        return this.pruneManager;
    }
}

