/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.core;

import java.math.BigInteger;
import org.ethereum.crypto.HashUtil;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.FastByteComparisons;
import org.ethereum.util.RLP;
import org.ethereum.util.RLPElement;
import org.ethereum.util.RLPList;

public class AccountState {
    private byte[] rlpEncoded;
    private final BigInteger nonce;
    private final BigInteger balance;
    private final byte[] stateRoot;
    private final byte[] codeHash;
    private final byte[] owner;

    public AccountState(BigInteger nonce, BigInteger balance) {
        this(nonce, balance, HashUtil.EMPTY_TRIE_HASH, HashUtil.EMPTY_DATA_HASH, null);
    }

    public AccountState(BigInteger nonce, BigInteger balance, byte[] owner) {
        this(nonce, balance, HashUtil.EMPTY_TRIE_HASH, HashUtil.EMPTY_DATA_HASH, owner);
    }

    public AccountState(BigInteger nonce, BigInteger balance, byte[] stateRoot, byte[] codeHash, byte[] owner) {
        this.nonce = nonce;
        this.balance = balance;
        this.stateRoot = stateRoot == HashUtil.EMPTY_TRIE_HASH || FastByteComparisons.equal(stateRoot, HashUtil.EMPTY_TRIE_HASH) ? HashUtil.EMPTY_TRIE_HASH : stateRoot;
        this.codeHash = codeHash == HashUtil.EMPTY_DATA_HASH || FastByteComparisons.equal(codeHash, HashUtil.EMPTY_DATA_HASH) ? HashUtil.EMPTY_DATA_HASH : codeHash;
        this.owner = owner == HashUtil.EMPTY_DATA_HASH || FastByteComparisons.equal(owner, HashUtil.EMPTY_DATA_HASH) ? HashUtil.EMPTY_DATA_HASH : owner;
    }

    public AccountState(byte[] rlpData) {
        this.rlpEncoded = rlpData;
        RLPList items = (RLPList)RLP.decode2(this.rlpEncoded).get(0);
        this.nonce = ByteUtil.bytesToBigInteger(((RLPElement)items.get(0)).getRLPData());
        this.balance = ByteUtil.bytesToBigInteger(((RLPElement)items.get(1)).getRLPData());
        this.stateRoot = ((RLPElement)items.get(2)).getRLPData();
        this.codeHash = ((RLPElement)items.get(3)).getRLPData();
        this.owner = ((RLPElement)items.get(4)).getRLPData();
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public AccountState withNonce(BigInteger nonce) {
        return new AccountState(nonce, this.balance, this.stateRoot, this.codeHash, this.owner);
    }

    public byte[] getStateRoot() {
        return this.stateRoot;
    }

    public AccountState withStateRoot(byte[] stateRoot) {
        return new AccountState(this.nonce, this.balance, stateRoot, this.codeHash, this.owner);
    }

    public AccountState withIncrementedNonce() {
        return new AccountState(this.nonce.add(BigInteger.ONE), this.balance, this.stateRoot, this.codeHash, this.owner);
    }

    public byte[] getCodeHash() {
        return this.codeHash;
    }

    public AccountState withCodeHash(byte[] codeHash) {
        return new AccountState(this.nonce, this.balance, this.stateRoot, codeHash, this.owner);
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public AccountState withBalanceIncrement(BigInteger value) {
        return new AccountState(this.nonce, this.balance.add(value), this.stateRoot, this.codeHash, this.owner);
    }

    public byte[] getOwner() {
        return this.owner;
    }

    public AccountState withOwner(byte[] owner) {
        return new AccountState(this.nonce, this.balance, this.stateRoot, this.codeHash, owner);
    }

    public byte[] getEncoded() {
        if (this.rlpEncoded == null) {
            byte[] nonce = RLP.encodeBigInteger(this.nonce);
            byte[] balance = RLP.encodeBigInteger(this.balance);
            byte[] stateRoot = RLP.encodeElement(this.stateRoot);
            byte[] codeHash = RLP.encodeElement(this.codeHash);
            byte[] owner = RLP.encodeElement(this.owner);
            this.rlpEncoded = RLP.encodeList(nonce, balance, stateRoot, codeHash, owner);
        }
        return this.rlpEncoded;
    }

    public boolean isEmpty() {
        return FastByteComparisons.equal(this.codeHash, HashUtil.EMPTY_DATA_HASH) && BigInteger.ZERO.equals(this.balance) && BigInteger.ZERO.equals(this.nonce);
    }

    public String toString() {
        String ret = "  Nonce: " + this.getNonce().toString() + "\n  Balance: " + this.getBalance() + "\n  State Root: " + ByteUtil.toHexString(this.getStateRoot()) + "\n  Code Hash: " + ByteUtil.toHexString(this.getCodeHash()) + "\n  Owner: " + ByteUtil.toHexString(this.getOwner());
        return ret;
    }
}

