/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.core;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.Arrays;
import org.ethereum.core.BlockHeader;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.RLP;
import org.ethereum.util.RLPList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Block {
    private static final Logger logger = LoggerFactory.getLogger((String)"blockchain");
    private BlockHeader header;
    private byte[] rlpEncoded;
    private boolean parsed = false;

    private Block() {
    }

    public Block(byte[] rawData) {
        logger.debug("new from [" + ByteUtil.toHexString(rawData) + "]");
        this.rlpEncoded = rawData;
    }

    public Block(byte[] parentHash, byte[] hash, long number) {
        this.header = new BlockHeader(parentHash, hash, number);
        this.parsed = true;
    }

    private synchronized void parseRLP() {
        if (this.parsed) {
            return;
        }
        RLPList params = RLP.decode2(this.rlpEncoded);
        RLPList block = (RLPList)params.get(0);
        RLPList header = (RLPList)block.get(0);
        this.header = new BlockHeader(header);
        this.parsed = true;
    }

    public BlockHeader getHeader() {
        this.parseRLP();
        return this.header;
    }

    public byte[] getHash() {
        this.parseRLP();
        return this.header.getHash();
    }

    public byte[] getParentHash() {
        this.parseRLP();
        return this.header.getParentHash();
    }

    public long getNumber() {
        this.parseRLP();
        return this.header.getNumber();
    }

    public boolean isEqual(Block block) {
        return Arrays.areEqual((byte[])this.getHash(), (byte[])block.getHash());
    }

    public byte[] getEncoded() {
        if (this.rlpEncoded == null) {
            byte[] header = this.header.getEncoded();
            List<byte[]> block = this.getBodyElements();
            block.add(0, header);
            byte[][] elements = (byte[][])block.toArray((T[])new byte[block.size()][]);
            this.rlpEncoded = RLP.encodeList(elements);
        }
        return this.rlpEncoded;
    }

    private List<byte[]> getBodyElements() {
        this.parseRLP();
        ArrayList<byte[]> body = new ArrayList<byte[]>();
        return body;
    }
}

