/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import java.util.HashMap;
import java.util.Map;
import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.BatchSource;

public class BatchSourceWriter<Key, Value>
extends AbstractChainedSource<Key, Value, Key, Value> {
    Map<Key, Value> buf = new HashMap<Key, Value>();

    public BatchSourceWriter(BatchSource<Key, Value> src) {
        super(src);
    }

    private BatchSource<Key, Value> getBatchSource() {
        return (BatchSource)this.getSource();
    }

    @Override
    public synchronized void delete(Key key) {
        this.buf.put(key, null);
    }

    @Override
    public synchronized void put(Key key, Value val) {
        this.buf.put(key, val);
    }

    @Override
    public Value get(Key key) {
        return (Value)this.getSource().get(key);
    }

    @Override
    public synchronized boolean flushImpl() {
        if (!this.buf.isEmpty()) {
            this.getBatchSource().updateBatch(this.buf);
            this.buf.clear();
            return true;
        }
        return false;
    }
}

