/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.datasource;

import org.ethereum.crypto.HashUtil;
import org.ethereum.datasource.AbstractChainedSource;
import org.ethereum.datasource.QuotientFilter;
import org.ethereum.datasource.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomedSource
extends AbstractChainedSource<byte[], byte[], byte[], byte[]> {
    private static final Logger logger = LoggerFactory.getLogger((String)"db");
    private byte[] filterKey = HashUtil.sha3("filterKey".getBytes());
    QuotientFilter filter;
    int hits = 0;
    int misses = 0;
    int falseMisses = 0;
    boolean dirty = false;
    int maxBloomSize;

    public BloomedSource(Source<byte[], byte[]> source, int maxBloomSize) {
        super(source);
        this.maxBloomSize = maxBloomSize;
        byte[] filterBytes = source.get(this.filterKey);
        if (filterBytes != null) {
            this.filter = filterBytes.length > 0 ? QuotientFilter.deserialize(filterBytes) : null;
        } else if (maxBloomSize > 0) {
            this.filter = QuotientFilter.create(50000000L, 100000L);
        } else {
            this.getSource().put(this.filterKey, new byte[0]);
        }
    }

    public void startBlooming(QuotientFilter filter) {
        this.filter = filter;
    }

    public void stopBlooming() {
        this.filter = null;
    }

    @Override
    public void put(byte[] key, byte[] val) {
        if (this.filter != null) {
            this.filter.insert(key);
            this.dirty = true;
            if (this.filter.getAllocatedBytes() > this.maxBloomSize) {
                logger.debug("Bloom filter became too large (" + this.filter.getAllocatedBytes() + " exceeds max threshold " + this.maxBloomSize + ") and is now disabled forever.");
                this.getSource().put(this.filterKey, new byte[0]);
                this.filter = null;
                this.dirty = false;
            }
        }
        this.getSource().put(key, val);
    }

    @Override
    public byte[] get(byte[] key) {
        if (this.filter == null) {
            return (byte[])this.getSource().get(key);
        }
        if (!this.filter.maybeContains(key)) {
            ++this.hits;
            return null;
        }
        byte[] ret = (byte[])this.getSource().get(key);
        if (ret == null) {
            ++this.falseMisses;
        } else {
            ++this.misses;
        }
        return ret;
    }

    @Override
    public void delete(byte[] key) {
        if (this.filter != null) {
            this.filter.remove(key);
        }
        this.getSource().delete(key);
    }

    @Override
    protected boolean flushImpl() {
        if (this.filter != null && this.dirty) {
            this.getSource().put(this.filterKey, this.filter.serialize());
            this.dirty = false;
            return true;
        }
        return false;
    }
}

